// SimRobXP.cpp : Defines the class behaviors for the application.
//

#include "StdAfx.h"
#include "../Controller/Controller.h"

#include "srDoc.h"
#include "srEditor.h"
#include "srEditorFrame.h"
#include "srTree.h"
#include "srObject.h"
#include "srObjectFrame.h"
#include "srBar.h"
#include "srConsole.h"
#include "srFrame.h"
#include "srSensor.h"
#include "srActuator.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CChild, CMDIChildWnd)
BOOL CChild::m_bTranslateChars = TRUE;

/////////////////////////////////////////////////////////////////////////////
// CApp

BEGIN_MESSAGE_MAP(CApp, CWinApp)
  //{{AFX_MSG_MAP(CApp)
  ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
  ON_COMMAND(ID_FILE_NEW, OnFileNew)
  //}}AFX_MSG_MAP
  // Standard file based document commands
  ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CApp construction

CApp::CApp()
{
  // TODO: add construction code here,
  // Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CApp object

CApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {2CC3DA20-9950-11CF-8437-444553540000}
static const CLSID clsid =
{ 0x2cc3da20, 0x9950, 0x11cf, { 0x84, 0x37, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

/////////////////////////////////////////////////////////////////////////////
// CApp initialization

BOOL CApp::InitInstance()
{
  // Initialize OLE libraries
  if (!AfxOleInit())
  {
    AfxMessageBox(IDP_OLE_INIT_FAILED);
    return FALSE;
  }

  // Standard initialization
  // If you are not using these features and wish to reduce the size
  //  of your final executable, you should remove from the following
  //  the specific initialization routines you do not need.

  InitGuiLibDLL();

  DWORD dwComCtlVer;
  CDllLoader dllLoader( _T("ComCtl32.dll") );
  if ( !dllLoader.GetVersion( &dwComCtlVer ) )
  {
      dwComCtlVer = PACKVERSION( 4, 0 );
  }

  if ( dwComCtlVer < PACKVERSION( 5, 81 ) )
  {
      CString strMsg;
      strMsg.Format(_T("SimRobot requires ComCtl32.dll version 5.81 or higher!\nInstalled version: %d.%02d"),
                    HIWORD(dwComCtlVer),LOWORD( dwComCtlVer));
      AfxMessageBox( strMsg );
  }

  SetRegistryKey("GermanTeam");

  LoadStdProfileSettings(); // Load standard INI file options (including MRU)

  // Register the application's document templates.  Document templates
  //  serve as the connection between documents, frame windows and views.

  m_pDocTemplate = new CMultiDocTemplate(IDR_EDITOR,RUNTIME_CLASS(CDoc),
                                         RUNTIME_CLASS(CEditorFrame),
                                         RUNTIME_CLASS(CEditor));
  AddDocTemplate(m_pDocTemplate);

  m_pTreeTemplate = new CMultiDocTemplate(IDR_TREE,RUNTIME_CLASS(CDoc),
                                          RUNTIME_CLASS(CChild),
                                          RUNTIME_CLASS(CTree));
  m_pObjectTemplate = new CMultiDocTemplate(IDR_OBJECT,RUNTIME_CLASS(CDoc),
                                            RUNTIME_CLASS(CObjectFrame),
                                            RUNTIME_CLASS(CObjectView));
  m_pSensorTemplate = new CMultiDocTemplate(IDR_SENSOR,RUNTIME_CLASS(CDoc),
                                            RUNTIME_CLASS(CChild),
                                            RUNTIME_CLASS(CSensor));
  m_pActuatorTemplate = new CMultiDocTemplate(IDR_ACTUATOR,RUNTIME_CLASS(CDoc),
                                           RUNTIME_CLASS(CChild),
                                           RUNTIME_CLASS(CActuator));

  // Connect the COleTemplateServer to the document template.
  //  The COleTemplateServer creates new documents on behalf
  //  of requesting OLE containers by using information
  //  specified in the document template.
  m_server.ConnectTemplate(clsid, m_pDocTemplate, FALSE);

  // Register all OLE server factories as running.  This enables the
  //  OLE libraries to create objects from other applications.
  COleTemplateServer::RegisterAll();
  // Note: MDI applications register all server objects without regard
  //  to the /Embedding or /Automation on the command line.

  // create main MDI Frame window
  CFrame* pMainFrame = new CFrame;
  if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
    return FALSE;
  m_pMainWnd = pMainFrame;

  // Enable drag/drop open
  m_pMainWnd->DragAcceptFiles();

  // Enable DDE Execute open
  EnableShellOpen();
  RegisterShellFileTypes();

  // Parse command line for standard shell commands, DDE, file open
  CCommandLineInfo cmdInfo;
  ParseCommandLine(cmdInfo);

  // Check to see if launched as OLE server
  if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
  {
    // Application was run with /Embedding or /Automation.  Don't show the
    //  main window in this case.
    return TRUE;
  }

  // When a server application is launched stand-alone, it is a good idea
  //  to update the system registry in case it has been damaged.
  m_server.UpdateRegistry(OAT_DISPATCH_OBJECT);
  COleObjectFactory::UpdateRegistryAll();

  // Dispatch commands specified on the command line
  if (!ProcessShellCommand(cmdInfo))
    return FALSE;

  // The main window has been initialized, so show and update it.
  pMainFrame->ShowWindow(m_nCmdShow,"");
  pMainFrame->UpdateWindow();

  return TRUE;
}

void CApp::CreateTree(CDocument* pDoc)
{
  CFrameWnd* pFrame = m_pTreeTemplate->CreateNewFrame(pDoc,0);
  m_pTreeTemplate->InitialUpdateFrame(pFrame,pDoc,TRUE);
}

void CApp::CreateObject(CDocument* pDoc)
{
  CFrameWnd* pFrame = m_pObjectTemplate->CreateNewFrame(pDoc,0);
  m_pObjectTemplate->InitialUpdateFrame(pFrame,pDoc,TRUE);
}

void CApp::CreateSensor(CDocument* pDoc)
{
  CFrameWnd* pFrame = m_pSensorTemplate->CreateNewFrame(pDoc,0);
  m_pSensorTemplate->InitialUpdateFrame(pFrame,pDoc,TRUE);
}

void CApp::CreateActuator(CDocument* pDoc)
{
  CFrameWnd* pFrame = m_pActuatorTemplate->CreateNewFrame(pDoc,0);
  m_pActuatorTemplate->InitialUpdateFrame(pFrame,pDoc,TRUE);
}

void CApp::HelpOnKeyword(const char* pKeyword)
{
  CString sKeyword(pKeyword);
  sKeyword.MakeUpper();
  CString s;
  for(int i = 2001; s.LoadString(i); i++)
    for(int j = 0; s.LoadString(i+j); j += 200)
      if(s == sKeyword)
      {
        WinHelp(i);
        return;
      }
  MessageBeep(MB_ICONEXCLAMATION);
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
  //{{AFX_DATA(CAboutDlg)
  enum { IDD = IDD_ABOUTBOX };
  //}}AFX_DATA

  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CAboutDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
  //}}AFX_VIRTUAL

// Implementation
protected:
  //{{AFX_MSG(CAboutDlg)
	  // No message handlers
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
  //{{AFX_DATA_INIT(CAboutDlg)
  //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAboutDlg)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
  //{{AFX_MSG_MAP(CAboutDlg)
    // No message handlers
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CApp::OnAppAbout()
{
  CAboutDlg aboutDlg;
  aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CApp commands

CDocument* CApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{
  AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_FILE_CLOSE);
  m_pWnd = 0;
  POSITION pos = m_pDocTemplate->GetFirstDocPosition();
  if(pos)
    return m_pDocTemplate->GetNextDoc(pos);
  else
  {
    CDocument* pDoc = CWinApp::OpenDocumentFile(lpszFileName);
    if(m_pWnd)
    {
      const CWnd* pWndFront = &CWnd::wndTop;
      for(int i = 0; i < m_nWindows; i++)
      {
        m_pWnd[i]->SetWindowPos(pWndFront,0,0,0,0,
          (i ? SWP_NOACTIVATE : 0) | SWP_NOMOVE | SWP_NOSIZE);
        pWndFront = m_pWnd[i];
      }
      delete [] m_pWnd;
    }
    return pDoc;
  }
}

int CApp::ExitInstance() 
{
  delete m_pTreeTemplate;
  delete m_pObjectTemplate;
  delete m_pSensorTemplate;
  delete m_pActuatorTemplate;
  return CWinApp::ExitInstance();
}

void CApp::OnFileNew() 
{
  AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_FILE_CLOSE);
  m_pWnd = 0;
  POSITION pos = m_pDocTemplate->GetFirstDocPosition();
  if(pos)
    return;
  else
    CWinApp::OnFileNew();
}
