// srBar.cpp : implementation file
//

#include "StdAfx.h"
#include "SimRobXP.h"
#include "srDoc.h"
#include "srObject.h"
#include "srBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNAMIC(CBar,CToolBarEx)

/////////////////////////////////////////////////////////////////////////////
// CBar

CBar::CBar()
{
  m_pObject = 0;
}

CBar::~CBar()
{
}

BEGIN_MESSAGE_MAP(CBar, CToolBarEx)
  //{{AFX_MSG_MAP(CBar)
  ON_UPDATE_COMMAND_UI(ID_ZOOM, OnUpdateZoom)
  ON_UPDATE_COMMAND_UI(ID_SURFACE, OnUpdateSurface)
  ON_UPDATE_COMMAND_UI(ID_PLANE, OnUpdatePlane)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBar message handlers

BOOL CBar::Create(CWnd* pWnd) 
{
  if(!CToolBarEx::Create(pWnd,WS_CHILD | WS_VISIBLE | CBRS_ALIGN_TOP | CBRS_FLYBY))
  {
    TRACE0("Failed to create toolbar\n");
    return FALSE;       // fail to create
  }
  else
    return TRUE;
}

void CBar::Init()
{
  static TBBUTTONEX tbButtons[] =
  {
    {{ 0,ID_FILE_NEW,       TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 1,ID_FILE_OPEN,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 2,ID_FILE_SAVE,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{ 3,ID_EDIT_CUT,       TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 4,ID_EDIT_COPY,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 5,ID_EDIT_PASTE,     TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{21,ID_PLANE,          TBSTATE_ENABLED,TBSTYLE_DROPDOWN | BTNS_WHOLEDROPDOWN,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{ 6,ID_VIEW_TREE,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 7,ID_VIEW_SELECTED,  TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{ 8,ID_ZOOM,           TBSTATE_ENABLED,TBSTYLE_DROPDOWN | BTNS_WHOLEDROPDOWN,0,0},true},
    {{ 9,ID_DETAIL_SENSORS, TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{11,ID_VIEW_LINE,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{12,ID_VIEW_COLUMN,    TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{13,ID_VIEW_MONO,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{14,ID_VIEW_COLOR,     TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{15,ID_VIEW_STEREO,    TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{10,ID_SURFACE,        TBSTATE_ENABLED,TBSTYLE_DROPDOWN | BTNS_WHOLEDROPDOWN,0,0},true},
    {{16,ID_VIEW_GRID,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{17,ID_SIM_RESET,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{18,ID_SIM_START,      TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{19,ID_SIM_STEP,       TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true},
    {{ 0,0,                 TBSTATE_ENABLED,TBSTYLE_SEP,   0,0},true},
    {{20,ID_CONTEXT_HELP,   TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0},true}
  };
  SetBitmaps(IDR_MAINFRAME,IDR_MAINFRAME,(UINT)-1,IDB_TOOLBARL,IDB_TOOLBARL,(UINT)-1,ioSmallIcons,RGB(192,192,192));
  SetButtons(sizeof(tbButtons) / sizeof(tbButtons[0]),tbButtons,toNoTextLabels);
}

bool CBar::HasButtonText(UINT nID)
{
  switch(nID)
  {
    case ID_VIEW_TREE:
    case ID_SIM_RESET:
    case ID_SIM_START:
    case ID_SIM_STEP:
      return true;
    default:
      return false;
  }
}

void CBar::OnUpdateZoom(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_pObject != 0);
}

void CBar::OnUpdateSurface(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_pObject != 0);
}

void CBar::OnUpdatePlane(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_pObject != 0);
}
