// srEditor.cpp : implementation of the CEditor class
//

#include "StdAfx.h"
#include "SimRobXP.h"

#include "srDoc.h"
#include "srEditor.h"
#include "srObject.h"
#include "srBar.h"
#include "srConsole.h"
#include "srFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditor

IMPLEMENT_DYNCREATE(CEditor, CEditView)

BEGIN_MESSAGE_MAP(CEditor, CEditView)
  //{{AFX_MSG_MAP(CEditor)
  ON_WM_CHAR()
  ON_COMMAND(ID_EDIT_INDENT, OnEditIndent)
  ON_COMMAND(ID_EDIT_UNINDENT, OnEditUnindent)
  ON_UPDATE_COMMAND_UI(ID_EDIT_UNINDENT, OnUpdateEditUnindent)
  ON_WM_RBUTTONUP()
  ON_COMMAND(ID_HELP, OnHelp)
  ON_WM_CREATE()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditor construction/destruction

CEditor::CEditor()
{
}

CEditor::~CEditor()
{
}

void CEditor::WriteLayout()
{
  CDoc* pDoc = GetDocument();
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  GetParent()->GetWindowPlacement(&wp);
  pDoc->NewSection("editorFrame");
  pDoc->WriteInt("flags",wp.flags);
  pDoc->WriteInt("show",wp.showCmd);
  pDoc->WriteInt("top",wp.rcNormalPosition.top);
  pDoc->WriteInt("bottom",wp.rcNormalPosition.bottom);
  pDoc->WriteInt("left",wp.rcNormalPosition.left);
  pDoc->WriteInt("right",wp.rcNormalPosition.right);
  pDoc->WriteInt("minX",wp.ptMinPosition.x);
  pDoc->WriteInt("minY",wp.ptMinPosition.y);
  pDoc->WriteInt("maxX",wp.ptMaxPosition.x);
  pDoc->WriteInt("maxY",wp.ptMaxPosition.y);

  CEdit& e = GetEditCtrl();
  int nStart,nStop;
  e.GetSel(nStart,nStop);
  pDoc->NewSection("editor");
  pDoc->WriteInt("firstVisibleLine",e.GetFirstVisibleLine());
  pDoc->WriteInt("selectionStart",nStart);
  pDoc->WriteInt("selectionStop",nStop);
}

void CEditor::RestoreLayout()
{
  CDoc* pDoc = GetDocument();
  if(!pDoc->IsRestoringLayout())
    return;
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  pDoc->NewSection("editorFrame");
  wp.flags = pDoc->ReadInt("flags");
  wp.showCmd = pDoc->ReadInt("show");
  wp.rcNormalPosition.top = pDoc->ReadInt("top");
  wp.rcNormalPosition.bottom = pDoc->ReadInt("bottom");
  wp.rcNormalPosition.left = pDoc->ReadInt("left");
  wp.rcNormalPosition.right = pDoc->ReadInt("right");
  wp.ptMinPosition.x = pDoc->ReadInt("minX");
  wp.ptMinPosition.y = pDoc->ReadInt("minY");
  wp.ptMaxPosition.x = pDoc->ReadInt("maxX");
  wp.ptMaxPosition.y = pDoc->ReadInt("maxY");
  GetParent()->SetWindowPlacement(&wp);

  CEdit& e = GetEditCtrl();
  pDoc->NewSection("editor");
  e.LineScroll(pDoc->ReadInt("firstVisibleLine"));
  e.SetSel(pDoc->ReadInt("selectionStart"),pDoc->ReadInt("selectionStop"));
}

/////////////////////////////////////////////////////////////////////////////
// CEditor diagnostics

#ifdef _DEBUG
void CEditor::AssertValid() const
{
  CEditView::AssertValid();
}

void CEditor::Dump(CDumpContext& dc) const
{
  CEditView::Dump(dc);
}

CDoc* CEditor::GetDocument() // non-debug version is inline
{
  ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDoc)));
  return (CDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CEditor message handlers

void CEditor::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  static char buf[256];
  CEdit& e = GetEditCtrl();
  int nStart,nStop;
  if(nChar == 13)
  {
    e.GetSel(nStart,nStop);
    int nPos = nStart - e.LineIndex(e.LineFromChar(nStart));
    buf[0] = '\r';
    buf[1] = '\n';
    e.GetLine(e.LineFromChar(nStart),buf+2,sizeof(buf)-2);
    int i = 2;
    while(i-2 < nPos && (buf[i] == ' ' || buf[i] == '\t'))
      i++;
    buf[i] = 0;
    e.ReplaceSel(buf);
  }
  else
    CEditView::OnChar(nChar, nRepCnt, nFlags);
}

void CEditor::OnEditIndent() 
{
  CEdit& e = GetEditCtrl();
  int nStart,nStop;
  e.GetSel(nStart,nStop);
  int lineStart = e.LineFromChar(nStart);
  if(nStart != nStop)
  {
    int lineStop = e.LineFromChar(nStop);
    nStart = e.LineIndex(lineStart);
    if(e.LineIndex(lineStop) != nStop)
      lineStop++;
    if(lineStop == e.GetLineCount())
      nStop = e.LineIndex(lineStop - 1) + e.LineLength(lineStop - 1) + 2;
    else
      nStop = e.LineIndex(lineStop);
    e.SetSel(nStart,nStop);
    int nSize = nStop-nStart+lineStop-lineStart+1,
        nOffset = 0;
    char* pData = new char [nSize];
    for(int i = lineStart; i < lineStop; i++)
    {
      pData[nOffset++] = ' ';
      nOffset += e.GetLine(i,pData+nOffset,nSize-nOffset);
      pData[nOffset++] = '\r';
      pData[nOffset++] = '\n';
    }
    pData[nOffset] = 0;
    e.ReplaceSel(pData);
    e.SetSel(nStart,nStop+lineStop-lineStart);
    delete [] pData;
  }
  else
  {
    int nPos = nStart - e.LineIndex(lineStart),
        nSize = ((nPos+8) / 8) * 8 - nPos;
    char *pSpace = "        ";
    e.ReplaceSel(pSpace+(8-nSize));
  }
}

void CEditor::OnEditUnindent() 
{
  static char buf[256];
  CEdit& e = GetEditCtrl();
  int nStart,nStop;
  e.GetSel(nStart,nStop);
  if (nStart != nStop)
  {
    int lineStart = e.LineFromChar(nStart),
        lineStop = e.LineFromChar(nStop);
    nStart = e.LineIndex(lineStart);
    if(e.LineIndex(lineStop) != nStop)
      lineStop++;
    if(lineStop == e.GetLineCount())
      nStop = e.LineIndex(lineStop - 1) + e.LineLength(lineStop - 1) + 2;
    else
      nStop = e.LineIndex(lineStop);
    e.SetSel(nStart,nStop);
    char *pData = new char [nStop-nStart+lineStop-lineStart+1];
    pData[0] = 0;
    for(int i = lineStart; i < lineStop; i++)
    {
      buf[e.GetLine(i,buf,sizeof(buf))] = 0;
      if(buf[0] == ' ')
      {
        strcat(pData,buf+1);
        nStop--;
      }
      else
        strcat(pData,buf);
            strcat(pData,"\r\n");
    }
    e.ReplaceSel(pData);
    e.SetSel(nStart,nStop);
    delete [] pData;
  }
}

void CEditor::OnUpdateEditUnindent(CCmdUI* pCmdUI) 
{
  int nStart,nStop;
  GetEditCtrl().GetSel(nStart,nStop);
  pCmdUI->Enable(nStart != nStop);
}

void CEditor::OnInitialUpdate() 
{
  GetParent()->ModifyStyle(FWS_ADDTOTITLE,0);
  GetParent()->SetWindowText("Editor");
  CEditView::OnInitialUpdate();
}


void CEditor::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
  if(lHint != UPDATE_ERROR)
    return;
  if(GetParent()->IsIconic())
    GetParent()->ShowWindow(SW_SHOWNORMAL);
  ((CMDIChildWnd*)GetParent())->MDIActivate();
  CPoint* p = (CPoint*) pHint;
  if(p->y)
  {
    CEdit& e = GetEditCtrl();
    int pos = e.LineIndex(p->y - 1) + p->x - 1;
    e.SetSel(pos,pos);
  }
}
void CEditor::OnRButtonUp(UINT nFlags, CPoint point) 
{
  ClientToScreen(&point);
  m_menuPopup.GetSubMenu(0)
    ->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
                     point.x,point.y,AfxGetMainWnd());
}

void CEditor::OnHelp() 
{
  if(((CFrameWnd*) AfxGetMainWnd())->IsTracking())
    CEditView::OnHelp();
  else
  {
    static char buf[256];
    CEdit& e = GetEditCtrl();
    int nStart,nStop;
    e.GetSel(nStart,nStop);
    nStart -= e.LineIndex();
    e.GetLine(e.LineFromChar(),buf,sizeof(buf));
    int nLength = strlen(buf);
    nStop = nStart;
    while (nStart+1 > 0 && (isalpha(buf[nStart]) || buf[nStart] == '_'))
      nStart--;
    while (nStop < nLength && (isalpha(buf[nStop]) || buf[nStop] == '_'))
      nStop++;
    buf[nStop] = 0;
    ((CApp*)AfxGetApp())->HelpOnKeyword(&buf[nStart+1]);
  }
}

int CEditor::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CEditView::OnCreate(lpCreateStruct) == -1)
    return -1;
  m_menuPopup.LoadMenu(IDP_EDITOR);
  HGDIOBJ font = GetStockObject(SYSTEM_FIXED_FONT);
  SendMessage(WM_SETFONT,(UINT)font,0L);
  return 0;
}
