// srFrame.cpp : implementation of the CFrame class
//

#include "stdafx.h"
#include "SimRobXP.h"

#include "srDoc.h"
#include "srObject.h"
#include "srBar.h"
#include "srConsole.h"
#include "srFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrame

IMPLEMENT_DYNAMIC(CFrame, CMDIFrameWndEx)

BEGIN_MESSAGE_MAP(CFrame, CMDIFrameWndEx)
  //{{AFX_MSG_MAP(CFrame)
  ON_WM_CREATE()
  ON_COMMAND(ID_VIEW_CONSOLE, OnViewConsole)
  ON_UPDATE_COMMAND_UI(ID_VIEW_CONSOLE, OnUpdateViewConsole)
	//}}AFX_MSG_MAP
  // Global help commands
  ON_COMMAND(ID_HELP_FINDER, CMDIFrameWndEx::OnHelpFinder)
  ON_COMMAND(ID_HELP, CMDIFrameWndEx::OnHelp)
  ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWndEx::OnContextHelp)
  ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWndEx::OnHelpFinder)
  ON_NOTIFY(TBN_DROPDOWN, AFX_IDW_TOOLBAR, OnDropDown)
END_MESSAGE_MAP()

static UINT indicators[] =
{
  ID_SEPARATOR,           // status line indicator
  ID_STEPS,
  ID_INDICATOR_CAPS,
  ID_INDICATOR_NUM,
};

/////////////////////////////////////////////////////////////////////////////
// CFrame construction/destruction

CFrame::CFrame()
{
}

CFrame::~CFrame()
{
}

void CFrame::WriteLayout()
{
  POSITION pos = AfxGetApp()->GetFirstDocTemplatePosition();
  CDocTemplate* pTempl = AfxGetApp()->GetNextDocTemplate(pos);
  pos = pTempl->GetFirstDocPosition();
  CDoc* pDoc = (CDoc*) pTempl->GetNextDoc(pos);
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  GetWindowPlacement(&wp);
  pDoc->NewSection("frame");
  pDoc->WriteInt("flags",wp.flags);
  pDoc->WriteInt("show",wp.showCmd);
  pDoc->WriteInt("top",wp.rcNormalPosition.top);
  pDoc->WriteInt("bottom",wp.rcNormalPosition.bottom);
  pDoc->WriteInt("left",wp.rcNormalPosition.left);
  pDoc->WriteInt("right",wp.rcNormalPosition.right);
  pDoc->WriteInt("minX",wp.ptMinPosition.x);
  pDoc->WriteInt("minY",wp.ptMinPosition.y);
  pDoc->WriteInt("maxX",wp.ptMaxPosition.x);
  pDoc->WriteInt("maxY",wp.ptMaxPosition.y);
  m_wndReBar.SaveState("");
  m_wndToolBar.SaveState("");
  SaveBarState("Console");
  CSizingControlBarG::GlobalSaveState(this);
}

void CFrame::RestoreLayout()
{
  POSITION pos = AfxGetApp()->GetFirstDocTemplatePosition();
  CDocTemplate* pTempl = AfxGetApp()->GetNextDocTemplate(pos);
  pos = pTempl->GetFirstDocPosition();
  CDoc* pDoc = (CDoc*) pTempl->GetNextDoc(pos);
  if(!pDoc->IsRestoringLayout())
    return;
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  pDoc->NewSection("frame");
  wp.flags = pDoc->ReadInt("flags");
  wp.showCmd = pDoc->ReadInt("show");
  AfxGetApp()->m_nCmdShow = wp.showCmd;
  wp.rcNormalPosition.top = pDoc->ReadInt("top");
  wp.rcNormalPosition.bottom = pDoc->ReadInt("bottom");
  wp.rcNormalPosition.left = pDoc->ReadInt("left");
  wp.rcNormalPosition.right = pDoc->ReadInt("right");
  wp.ptMinPosition.x = pDoc->ReadInt("minX");
  wp.ptMinPosition.y = pDoc->ReadInt("minY");
  wp.ptMaxPosition.x = pDoc->ReadInt("maxX");
  wp.ptMaxPosition.y = pDoc->ReadInt("maxY");
  SetWindowPlacement(&wp);
  m_wndReBar.LoadState("");
  m_wndToolBar.LoadState("");
  m_wndToolBar.LoadState(""); // load twice to avoid painting errors
  CSizingControlBarG::GlobalLoadState(this);
  LoadBarState("Console");
}
  
int CFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  if (CMDIFrameWndEx::OnCreate(lpCreateStruct) == -1)
    return -1;
	
  if(!m_wndToolBar.Create(this))
    return -1;

  if (!m_wndReBar.AddBar(&m_wndToolBar,
      0,0,RBBS_GRIPPERALWAYS|RBBS_FIXEDBMP|RBBS_BREAK,"&Standard", false))
  {
    TRACE0("Failed to create rebar\n");
    return -1;      // fail to create
  }
  m_wndToolBar.ModifyStyle(0,CCS_ADJUSTABLE);
  m_wndToolBar.Init();

  if (!m_wndConsoleBar.Create("Console",this,ID_CONSOLE))
  {
    TRACE0("Failed to create mybar\n");
    return -1;		// fail to create
  }

  m_wndConsoleBar.SetBarStyle(m_wndConsoleBar.GetBarStyle() |
                              CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

  if(!m_wndStatusBar.Create(this) ||
     !m_wndStatusBar.SetIndicators(indicators,
                                   sizeof(indicators)/sizeof(UINT)))
  {
    TRACE0("Failed to create status bar\n");
    return -1;      // fail to create
  }

  CWinAppEx* pApp = CWinAppEx::GetInstance();
  CMapUIntToInt mapIDToImage;
  mapIDToImage[ ID_FILE_NEW           ] = 0;
  mapIDToImage[ ID_FILE_OPEN          ] = 1;
  mapIDToImage[ ID_FILE_SAVE          ] = 2;
  mapIDToImage[ ID_EDIT_CUT           ] = 3;
  mapIDToImage[ ID_EDIT_COPY          ] = 4;
  mapIDToImage[ ID_EDIT_PASTE         ] = 5;
  mapIDToImage[ ID_VIEW_TREE          ] = 6;
  mapIDToImage[ ID_VIEW_SELECTED      ] = 7;
  mapIDToImage[ ID_DETAIL_SENSORS     ] = 9;
  mapIDToImage[ ID_VIEW_LINE          ] = 11;
  mapIDToImage[ ID_VIEW_COLUMN        ] = 12;
  mapIDToImage[ ID_VIEW_MONO          ] = 13;
  mapIDToImage[ ID_VIEW_COLOR         ] = 14;
  mapIDToImage[ ID_VIEW_STEREO        ] = 15;
  mapIDToImage[ ID_VIEW_GRID          ] = 16;
  mapIDToImage[ ID_SIM_RESET          ] = 17;
  mapIDToImage[ ID_SIM_START          ] = 18;
  mapIDToImage[ ID_SIM_STEP           ] = 19;
  mapIDToImage[ ID_CONTEXT_HELP       ] = 20;
  pApp->AddMenuIcon(mapIDToImage,IDR_MAINFRAME,RGB(192,192,192));
  mapIDToImage.RemoveAll();

  mapIDToImage[ SC_NEXTWINDOW       ] = 0;
  mapIDToImage[ SC_PREVWINDOW       ] = 1;
  mapIDToImage[ ID_WINDOW_NEW       ] = 2;
  mapIDToImage[ ID_WINDOW_CASCADE   ] = 3;
  mapIDToImage[ ID_WINDOW_TILE_HORZ ] = 4;
  mapIDToImage[ ID_WINDOW_TILE_VERT ] = 5;
  mapIDToImage[ ID_WINDOW_LIST      ] = 6;
  mapIDToImage[ ID_EDIT_UNDO        ] = 7;
  mapIDToImage[ ID_EDIT_REDO        ] = 8;
  mapIDToImage[ ID_EDIT_FIND        ] = 9;
  pApp->AddMenuIcon(mapIDToImage, IDB_MENU);
  mapIDToImage.RemoveAll();

  m_wndConsoleBar.EnableDocking(CBRS_ALIGN_ANY);
  EnableDocking(CBRS_ALIGN_ANY);
  DockControlBar(&m_wndConsoleBar, AFX_IDW_DOCKBAR_BOTTOM);
  ShowControlBar(&m_wndConsoleBar,FALSE,FALSE);
  return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CFrame diagnostics

#ifdef _DEBUG
void CFrame::AssertValid() const
{
  CMDIFrameWndEx::AssertValid();
}

void CFrame::Dump(CDumpContext& dc) const
{
  CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFrame message handlers

void CFrame::OnDropDown(NMHDR* pNotifyStruct,LRESULT* pResult)
{
  NMTOOLBAR* pNMToolBar = (NMTOOLBAR*) pNotifyStruct;

  CMenu menu;
  CMenu* pPopup = 0;

  switch (pNMToolBar->iItem)
  {
    case ID_ZOOM:
      VERIFY(menu.LoadMenu(IDP_ZOOM));
      pPopup = menu.GetSubMenu(0);
      break;
    case ID_SURFACE:
      VERIFY(menu.LoadMenu(IDP_SURFACE));
      pPopup = menu.GetSubMenu(0);
      break;
    case ID_PLANE:
      VERIFY(menu.LoadMenu(IDP_PLANE));
      pPopup = menu.GetSubMenu(0);
      break;
    default:
      ASSERT( false );
  }

  if(pPopup)
  {
    CRect rc;
    ::SendMessage(pNMToolBar->hdr.hwndFrom,
                  TB_GETRECT,pNMToolBar->iItem,(LPARAM) &rc);
    rc.top = rc.bottom;
    ::ClientToScreen(pNMToolBar->hdr.hwndFrom,&rc.TopLeft());
    pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON,rc.left,rc.top,this);
  }
  *pResult = TBDDRET_DEFAULT;
}

void CFrame::OnViewConsole() 
{
  ShowControlBar(&m_wndConsoleBar,!m_wndConsoleBar.IsVisible(),FALSE);
}

void CFrame::OnUpdateViewConsole(CCmdUI* pCmdUI) 
{
  pCmdUI->SetCheck(m_wndConsoleBar.IsVisible());
}
