// srObjectFrame.cpp : implementation file
//

#include "StdAfx.h"
#include "SimRobXP.h"
#include "srDoc.h"
#include "srObject.h"
#include "srObjectFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectFrame

IMPLEMENT_DYNCREATE(CObjectFrame, CChild)

CObjectFrame::CObjectFrame()
{
}

CObjectFrame::~CObjectFrame()
{
}

void CObjectFrame::WriteLayout()
{
  CDoc* pDoc = m_pObject->GetDocument();
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  GetWindowPlacement(&wp);
  pDoc->NewSection("objectFrame");
  pDoc->WriteInt("flags",wp.flags);
  pDoc->WriteInt("show",wp.showCmd);
  pDoc->WriteInt("top",wp.rcNormalPosition.top);
  pDoc->WriteInt("bottom",wp.rcNormalPosition.bottom);
  pDoc->WriteInt("left",wp.rcNormalPosition.left);
  pDoc->WriteInt("right",wp.rcNormalPosition.right);
  pDoc->WriteInt("minX",wp.ptMinPosition.x);
  pDoc->WriteInt("minY",wp.ptMinPosition.y);
  pDoc->WriteInt("maxX",wp.ptMaxPosition.x);
  pDoc->WriteInt("maxY",wp.ptMaxPosition.y);
  pDoc->WriteInt("paintWhileTurning",m_bTurn);
  pDoc->WriteInt("scrollHorz",GetScrollPos(SB_HORZ));
  pDoc->WriteInt("scrollVert",GetScrollPos(SB_VERT));
}

void CObjectFrame::RestoreLayout()
{
  CDoc* pDoc = m_pObject->GetDocument();
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  pDoc->NewSection("objectFrame");
  wp.flags = pDoc->ReadInt("flags");
  wp.showCmd = pDoc->ReadInt("show");
  wp.rcNormalPosition.top = pDoc->ReadInt("top");
  wp.rcNormalPosition.bottom = pDoc->ReadInt("bottom");
  wp.rcNormalPosition.left = pDoc->ReadInt("left");
  wp.rcNormalPosition.right = pDoc->ReadInt("right");
  wp.ptMinPosition.x = pDoc->ReadInt("minX");
  wp.ptMinPosition.y = pDoc->ReadInt("minY");
  wp.ptMaxPosition.x = pDoc->ReadInt("maxX");
  wp.ptMaxPosition.y = pDoc->ReadInt("maxY");
  SetWindowPlacement(&wp);
  m_bTurn = pDoc->ReadInt("paintWhileTurning");
  SetScrollPos(SB_HORZ,pDoc->ReadInt("scrollHorz"));
  SetScrollPos(SB_VERT,pDoc->ReadInt("scrollVert"));
}

BEGIN_MESSAGE_MAP(CObjectFrame, CMDIChildWnd)
  //{{AFX_MSG_MAP(CObjectFrame)
  ON_COMMAND(ID_VIEW_TURN, OnViewTurn)
  ON_UPDATE_COMMAND_UI(ID_VIEW_TURN, OnUpdateViewTurn)
  ON_WM_HSCROLL()
  ON_WM_VSCROLL()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectFrame message handlers

BOOL CObjectFrame::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CMDIFrameWnd* pParentWnd, CCreateContext* pContext) 
{
  if(CMDIChildWnd::Create(lpszClassName, lpszWindowName, dwStyle & ~FWS_ADDTOTITLE | WS_HSCROLL | WS_VSCROLL,
                          rect, pParentWnd, pContext))
  {
    SetScrollRange(SB_HORZ,0,360,FALSE);
    SetScrollRange(SB_VERT,0,360,FALSE);
    SetScrollPos(SB_VERT,225,FALSE);
    SetScrollPos(SB_HORZ,180,FALSE);
    m_bTurn = TRUE;
    return TRUE;
  }
  else
    return FALSE;
}

void CObjectFrame::OnViewTurn() 
{
  if(m_pObject->GetDocument()->GetSimulation())
    m_bTurn ^= 1;
}

void CObjectFrame::OnUpdateViewTurn(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(m_pObject->GetDocument()->GetSimulation() != 0);
  pCmdUI->SetCheck(m_bTurn);
}

void CObjectFrame::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  OnScroll(SB_HORZ, nSBCode, nPos);
}

void CObjectFrame::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  OnScroll(SB_VERT, nSBCode, nPos);
}

void CObjectFrame::OnScroll(UINT nBar, UINT nSBCode, UINT nPos)
{
  int zOrig, z;   // z = x or y depending on 'nBar'
  int zMin, zMax;
  zOrig = z = GetScrollPos(nBar);
  GetScrollRange(nBar,&zMin,&zMax);
  switch (nSBCode)
  {
    case SB_TOP:
      z = 0;
      break;
    case SB_BOTTOM:
      z = zMax;
      break;
    case SB_LINEUP:
      z -= 10;
      break;
    case SB_LINEDOWN:
      z += 10;
      break;
    case SB_PAGEUP:
      z -= 90;
      break;
    case SB_PAGEDOWN:
      z += 90;
      break;
    case SB_THUMBTRACK:
      if(!m_bTurn)
        return;
      z = nPos;
      break;
    case SB_THUMBPOSITION:
      z = nPos;
      break;
    default:        // ignore other notifications
      return;
  }
  if (z < 0)
    z = 0;
  else if (z > zMax)
    z = zMax;
  if (z != zOrig)
  {
    SetScrollPos(nBar,z);
    m_pObject->Invalidate(false);
  }
}
