// srTree.cpp : implementation file
//

#include "StdAfx.h"
#include "SimRobXP.h"
#include "srDoc.h"
#include "srTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTree

IMPLEMENT_DYNCREATE(CTree, CTreeView)

CTree::CTree()
{
}

CTree::~CTree()
{
}

void CTree::WriteLayout()
{
  CDoc* pDoc = GetDocument();
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  GetParent()->GetWindowPlacement(&wp);
  pDoc->NewSection("treeFrame");
  pDoc->WriteInt("flags",wp.flags);
  pDoc->WriteInt("show",wp.showCmd);
  pDoc->WriteInt("top",wp.rcNormalPosition.top);
  pDoc->WriteInt("bottom",wp.rcNormalPosition.bottom);
  pDoc->WriteInt("left",wp.rcNormalPosition.left);
  pDoc->WriteInt("right",wp.rcNormalPosition.right);
  pDoc->WriteInt("minX",wp.ptMinPosition.x);
  pDoc->WriteInt("minY",wp.ptMinPosition.y);
  pDoc->WriteInt("maxX",wp.ptMaxPosition.x);
  pDoc->WriteInt("maxY",wp.ptMaxPosition.y);

  pDoc->NewSection("tree");
  pDoc->WriteString("selected",pDoc->GetSimulation() ? GetSelectedObject() : m_sSelected);
}

bool CTree::RestoreLayout()
{
  CDoc* pDoc = GetDocument();
  if(!pDoc->IsRestoringLayout())
    return false;
  WINDOWPLACEMENT wp;
  wp.length = sizeof(wp);
  pDoc->NewSection("treeFrame");
  wp.flags = pDoc->ReadInt("flags");
  wp.showCmd = pDoc->ReadInt("show");
  wp.rcNormalPosition.top = pDoc->ReadInt("top");
  wp.rcNormalPosition.bottom = pDoc->ReadInt("bottom");
  wp.rcNormalPosition.left = pDoc->ReadInt("left");
  wp.rcNormalPosition.right = pDoc->ReadInt("right");
  wp.ptMinPosition.x = pDoc->ReadInt("minX");
  wp.ptMinPosition.y = pDoc->ReadInt("minY");
  wp.ptMaxPosition.x = pDoc->ReadInt("maxX");
  wp.ptMaxPosition.y = pDoc->ReadInt("maxY");
  GetParent()->SetWindowPlacement(&wp);

  pDoc->NewSection("tree");
  m_sSelected = pDoc->ReadString("selected");
  return true;
}

BEGIN_MESSAGE_MAP(CTree, CTreeView)
  //{{AFX_MSG_MAP(CTree)
  ON_COMMAND(ID_HELP, OnHelp)
  ON_WM_RBUTTONUP()
  ON_WM_RBUTTONDOWN()
  ON_COMMAND(ID_VIEW_SELECTED, OnViewSelected)
  ON_UPDATE_COMMAND_UI(ID_VIEW_SELECTED, OnUpdateViewSelected)
  ON_WM_LBUTTONDBLCLK()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTree diagnostics

#ifdef _DEBUG
void CTree::AssertValid() const
{
  CTreeView::AssertValid();
}

void CTree::Dump(CDumpContext& dc) const
{
  CTreeView::Dump(dc);
}

CDoc* CTree::GetDocument() // non-debug version is inline
{
  ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDoc)));
  return (CDoc*)m_pDocument;
}
#endif //_DEBUG

void CTree::InsertObject(std::vector<ObjectDescription>::const_iterator& iter,HTREEITEM hParent)
{
  CTreeCtrl& t = GetTreeCtrl();
  HTREEITEM hThis = t.InsertItem(TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_TEXT | TVIF_STATE,
                                 (iter->kind + " " + iter->name).c_str(),0,0,
                                 hParent ? 0 : TVIS_EXPANDED,
                                 TVIS_EXPANDED | TVIS_SELECTED,
                                 0,hParent,TVI_LAST);
  int depth = iter->depth;
  ++iter;
  HTREEITEM hLastPort = TVI_FIRST;
  while(iter != GetDocument()->GetObjectDescriptionTree().end() &&
        iter->depth == depth + 1)
    switch(iter->type)
    {
      case OBJECT_TYPE_NONE:
      case OBJECT_TYPE_OBJECT:
        InsertObject(iter,hThis);
        break;
      case OBJECT_TYPE_SENSORPORT:
        hLastPort = t.InsertItem(TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_TEXT,
                                 iter->name.c_str(),1,1,0,0,0,hThis,hLastPort);
        ++iter;
        break;
      case OBJECT_TYPE_ACTUATORPORT:
        hLastPort = t.InsertItem(TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_TEXT,
                     iter->name.c_str(),2,2,0,0,0,hThis,hLastPort);
        ++iter;
  }
}

CString CTree::GetNameFromItem(HTREEITEM hItem) const
{
  CTreeCtrl& t = GetTreeCtrl();
  CString sName = t.GetItemText(hItem);
  int p = sName.Find(' ');
  if(p != -1)
    sName = sName.Mid(p+1);
  if(hItem == t.GetRootItem())
    return sName;
  else
    return GetNameFromItem(t.GetParentItem(hItem)) + "." + sName;
}

HTREEITEM CTree::GetItemFromName2(CString s,HTREEITEM hItem) const
{
  CTreeCtrl& t = GetTreeCtrl();
  int p = s.Find('.');
  CString sFirst = p != -1 ? s.Left(p) : s,
          sLast = p != -1 ? s.Mid(p+1) : "";
  while(hItem)
  {
    CString sName = t.GetItemText(hItem);
    int p = sName.Find(' ');
    if(p != -1)
      sName = sName.Mid(p+1);
    if(sName == sFirst)
      if(sLast == "")
        return hItem;
      else
        return GetItemFromName2(sLast,t.GetChildItem(hItem));
    hItem = t.GetNextSiblingItem(hItem);
  }
  return 0;
}

HTREEITEM CTree::GetItemFromName(CString s) const
{
  return GetItemFromName2(s,GetTreeCtrl().GetRootItem());
}

CString CTree::GetSelectedObject() const
{
  CTreeCtrl& t = GetTreeCtrl();
  HTREEITEM hItem = t.GetSelectedItem();
  ASSERT(hItem);
  return GetNameFromItem(hItem);
}

/////////////////////////////////////////////////////////////////////////////
// CTree message handlers

void CTree::OnInitialUpdate() 
{
  if(!RestoreLayout())
  {
    CRect rect;
    GetParent()->GetParent()->GetClientRect(&rect);
    GetParent()->SetWindowPos(0,0,0,rect.right / 3,rect.bottom,SWP_NOZORDER);
  }
  GetParent()->ModifyStyle(FWS_ADDTOTITLE,0);
  GetParent()->SetWindowText("Tree");
  m_menuPopup.LoadMenu(IDP_TREE);
  CTreeCtrl& t = GetTreeCtrl();
  t.ModifyStyle(0,TVS_HASLINES | TVS_HASBUTTONS | TVS_LINESATROOT);
  m_ImageList.Create(IDB_TREE,16,0,RGB(255,0,0));
  t.SetImageList(&m_ImageList,TVSIL_NORMAL);
  CTreeView::OnInitialUpdate();
}

void CTree::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
  if(lHint > UPDATE_SUCCESS && (!GetDocument()->GetSimulation() || 
     !GetDocument()->GetSimulation()->hasSceneGraphChanged()))
    return;
  CTreeCtrl& t = GetTreeCtrl();
  HTREEITEM hItem = t.GetSelectedItem();
  if(hItem)
    m_sSelected = GetNameFromItem(hItem);
  t.DeleteAllItems();
  if(GetDocument()->GetSimulation())
  {
    std::vector<ObjectDescription>::const_iterator iter = GetDocument()->GetObjectDescriptionTree().begin();
    InsertObject(iter,0);
    HTREEITEM hItem = GetItemFromName(m_sSelected);
    if(!hItem)
      hItem = t.GetRootItem();
    t.EnsureVisible(hItem);
    t.SelectItem(hItem);
  }
  Invalidate();
}

void CTree::OnRButtonDown(UINT nFlags, CPoint point) 
{
}

void CTree::OnRButtonUp(UINT nFlags, CPoint point) 
{
  CTreeCtrl& t = GetTreeCtrl();
  HTREEITEM hItem = t.HitTest(point);
  if(hItem)
    t.SelectItem(hItem);
  ClientToScreen(&point);
  m_menuPopup.GetSubMenu(0)
    ->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
                     point.x,point.y,AfxGetMainWnd());
}

void CTree::OnHelp() 
{
  if(((CFrameWnd*) AfxGetMainWnd())->IsTracking())
    CTreeView::OnHelp();
  else
  {
    CTreeCtrl& t = GetTreeCtrl();
    HTREEITEM hItem = t.GetSelectedItem();
    if(hItem)
    {
      CString sKeyword = t.GetItemText(hItem);
      sKeyword = sKeyword.Left(sKeyword.Find(' '));
      ((CApp*) AfxGetApp())->HelpOnKeyword(sKeyword);
    }
  }
}

void CTree::OnViewSelected() 
{
  CApp* pApp = (CApp*) AfxGetApp();
  CDoc* pDoc = GetDocument();

  if(pDoc->GetSimulation())
    switch(GetDocument()->GetType(GetSelectedObject()))
    {
      case OBJECT_TYPE_OBJECT:
        pApp->CreateObject(pDoc);
        break;
      case OBJECT_TYPE_ACTUATORPORT:
        pApp->CreateActuator(pDoc);
        break;
      case OBJECT_TYPE_SENSORPORT:
        pApp->CreateSensor(pDoc);
        break;
    }
}

void CTree::OnUpdateViewSelected(CCmdUI* pCmdUI) 
{
  pCmdUI->Enable(GetDocument()->GetSimulation() != 0);
}

void CTree::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
  OnViewSelected();
}
