// srTree.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CTree view

class CTree : public CTreeView
{
private:
  CMenu m_menuPopup;
  CImageList m_ImageList;
  CString m_sSelected;

  void InsertObject(std::vector<ObjectDescription>::const_iterator& iter,HTREEITEM hParent);
  CString GetNameFromItem(HTREEITEM hItem) const;
  HTREEITEM GetItemFromName2(CString s,HTREEITEM hItem) const;
  HTREEITEM GetItemFromName(CString s) const;
  bool RestoreLayout();

public:
  CString GetSelectedObject() const;
  void WriteLayout();

protected:
  CTree();           // protected constructor used by dynamic creation
  DECLARE_DYNCREATE(CTree)

// Attributes
public:
  CDoc* GetDocument();

// Operations
public:

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CTree)
  public:
  virtual void OnInitialUpdate();
  protected:
  virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
  //}}AFX_VIRTUAL

// Implementation
protected:
  virtual ~CTree();
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

  // Generated message map functions
protected:
  //{{AFX_MSG(CTree)
  afx_msg void OnHelp();
  afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnViewSelected();
  afx_msg void OnUpdateViewSelected(CCmdUI* pCmdUI);
  afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#ifndef _DEBUG  // debug version in srTree.cpp
inline CDoc* CTree::GetDocument()
   { return (CDoc*)m_pDocument; }
#endif
