/////////////////////////////////////////////////////////////////////////////
// FrameWndEx.cpp: implementation of the frame classes.
//
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2002 by Nikolay Denisov. All rights reserved.
//
// This code is free for personal and commercial use, providing this 
// notice remains intact in the source files and all eventual changes are
// clearly marked with comments.
//
// You must obtain the author's consent before you can include this code
// in a software library.
//
// No warrantee of any kind, express or implied, is included with this
// software; use at your own risk, responsibility for damages (if any) to
// anyone resulting from the use of this software rests entirely with the
// user.
//
// Please email bug reports, bug fixes, enhancements, requests and
// comments to: acnick@mail.lanck.net
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FrameWndEx.h"
#include "WindowListDialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrameWndEx

IMPLEMENT_DYNCREATE( CFrameWndEx, CFrameWnd )

CFrameWndEx::CFrameWndEx()
{
}

CFrameWndEx::~CFrameWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// Overrides

void CFrameWndEx::DelayUpdateFrameMenu( HMENU hMenuAlt )
{
    // This function seems to be called by the framework only two times
    // when in-place activation begins and ends.

    if ( m_bInPlace )
    {
        VERIFY( SetMenu( 0 ) );
    }

    m_bInPlace = !m_bInPlace;

    CFrameWnd::DelayUpdateFrameMenu( hMenuAlt );
}

void CFrameWndEx::OnUpdateFrameMenu( HMENU hMenuAlt )
{
    if ( hMenuAlt == 0 )
    {
        // Attempt to get default menu from document
        CDocument* pDoc = GetActiveDocument();
        if ( pDoc != 0 )
        {
            hMenuAlt = pDoc->GetDefaultMenu();
        }
        // Use default menu stored in frame if none from document
        if ( hMenuAlt == 0 )
        {
            hMenuAlt = m_hMenuDefault;
        }
    }

    // Finally, set the menu
    if ( m_bInPlace )
    {
        VERIFY( ::SetMenu( m_hWnd, hMenuAlt ) );
    }
    else
    {
        VERIFY( m_wndMenuBar.SetMenu( hMenuAlt ) );
    }
}

/////////////////////////////////////////////////////////////////////////////
// CFrameWndEx message handlers

BEGIN_MESSAGE_MAP(CFrameWndEx, CFrameWnd)
    //{{AFX_MSG_MAP(CFrameWndEx)
    ON_WM_CREATE()
    ON_WM_SYSCOMMAND()
    ON_WM_MENUCHAR()
    ON_WM_NCACTIVATE()
    ON_WM_SETTINGCHANGE()
    ON_WM_CLOSE()
    ON_WM_INITMENUPOPUP()
    ON_WM_MENUSELECT()
    ON_WM_DRAWITEM()
    ON_WM_MEASUREITEM()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMDIClientWndEx

IMPLEMENT_DYNCREATE( CMDIClientWndEx, CWnd )

CMDIClientWndEx::CMDIClientWndEx() : m_hWindowMenu( 0 )
{
}

CMDIClientWndEx::~CMDIClientWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// Implementation

CMDIFrameWndEx* CMDIClientWndEx::GetParentFrame() const
{
    return STATIC_DOWNCAST( CMDIFrameWndEx, CWnd::GetParentFrame() );
}

/////////////////////////////////////////////////////////////////////////////
// CMDIClientWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIClientWndEx, CWnd)
    //{{AFX_MSG_MAP(CMDIClientWndEx)
    //}}AFX_MSG_MAP
    ON_MESSAGE( WM_MDISETMENU, OnMDISetMenu )
    ON_MESSAGE( WM_MDIREFRESHMENU, OnMDIRefreshMenu )
END_MESSAGE_MAP()

LRESULT CMDIClientWndEx::OnMDISetMenu( WPARAM wParam, LPARAM lParam )
{
    m_hWindowMenu = ( HMENU )lParam;

    CMDIFrameWndEx* pFrame = GetParentFrame();
    if ( !pFrame->m_bInPlace )
    {
        VERIFY( pFrame->m_wndMenuBar.SetMenu( ( HMENU )wParam ) );
        wParam = 0;
    }

    return DefWindowProc( WM_MDISETMENU, wParam, lParam );
}

LRESULT CMDIClientWndEx::OnMDIRefreshMenu( WPARAM wParam, LPARAM lParam )
{
    LRESULT lResult = DefWindowProc( WM_MDIREFRESHMENU, wParam, lParam );

    CMenu* pWindowMenu = CMenu::FromHandle( m_hWindowMenu );
    if ( pWindowMenu != 0 )
    {
        CWinAppEx* pApp = CWinAppEx::GetInstance();
        UINT nItems = pWindowMenu->GetMenuItemCount();
        for ( UINT nIndex = 0; nIndex < nItems; nIndex++ )
        {
            UINT nID = pWindowMenu->GetMenuItemID( nIndex );
            if ( nID >= AFX_IDM_FIRST_MDICHILD )
            {
                HICON hIcon = ( HICON )::GetClassLong(
                    GetDlgItem( nID )->GetSafeHwnd(), GCL_HICONSM );
                if ( hIcon != 0 )
                {
                    pApp->ReplaceMenuIcon( nID, hIcon );
                }
                else
                {
                    pApp->RemoveMenuIcon( nID );
                }
            }
        }

        pWindowMenu->RemoveMenu( ID_WINDOW_LIST, MF_BYCOMMAND );
        pWindowMenu->RemoveMenu( AFX_IDM_FIRST_MDICHILD + 9, MF_BYCOMMAND ); // "More Windows..."

        CString strText;
        VERIFY( strText.LoadString( IDS_WINDOW_LIST ) );
        VERIFY( pWindowMenu->AppendMenu( MF_STRING, ID_WINDOW_LIST, strText ) );
    }

    return lResult;
}

/////////////////////////////////////////////////////////////////////////////
// CMDIFrameWndEx

IMPLEMENT_DYNCREATE( CMDIFrameWndEx, CMDIFrameWnd )

CMDIFrameWndEx::CMDIFrameWndEx()
{
}

CMDIFrameWndEx::~CMDIFrameWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// Overrides

void CMDIFrameWndEx::DelayUpdateFrameMenu( HMENU hMenuAlt )
{
    // This function seems to be called by the framework only two times
    // when in-place activation begins and ends.

    if ( m_bInPlace )
    {
        CMenu* pFrameMenu = GetMenu();
        VERIFY( SetMenu( 0 ) );

        if ( pFrameMenu != 0 )
        {
            BOOL bMaximized;
            CMDIChildWnd* pActive = MDIGetActive( &bMaximized );
            if ( ( pActive!= 0 ) && bMaximized )
            {
                if ( pFrameMenu->GetSubMenu( 0 ) == pActive->GetSystemMenu( FALSE ) )
                {
                    VERIFY( pFrameMenu->RemoveMenu( 0, MF_BYPOSITION ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_MINIMIZE, MF_BYCOMMAND ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_RESTORE, MF_BYCOMMAND ) );
                    VERIFY( pFrameMenu->DeleteMenu( SC_CLOSE, MF_BYCOMMAND ) );
                    VERIFY( pActive->ModifyStyle( 0, WS_SYSMENU ) );
                }
            }
        }
    }

    m_bInPlace = !m_bInPlace;

    CMDIFrameWnd::DelayUpdateFrameMenu( hMenuAlt );
}

void CMDIFrameWndEx::OnUpdateFrameTitle( BOOL bAddToTitle )
{
    CFrameWndBase< CMDIFrameWnd >::OnUpdateFrameTitle( bAddToTitle );

    // If our MDIChildFrame was created with ( WS_VISIBLE | FWS_ADDTOTITLE )
    // styles, then we have to refresh Window menu in order to reflect
    // MDIChildFrame title changes.  CMDIChildWnd::OnUpdateFrameTitle()
    // calls CMDIFrameWnd::OnUpdateFrameTitle(), so here we go.
    VERIFY( m_wndMDIClient.PostMessage( WM_MDIREFRESHMENU ) );
}

/////////////////////////////////////////////////////////////////////////////
// CMDIFrameWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIFrameWndEx, CMDIFrameWnd)
    //{{AFX_MSG_MAP(CMDIFrameWndEx)
    ON_WM_CREATE()
    ON_WM_SYSCOMMAND()
    ON_WM_MENUCHAR()
    ON_WM_NCACTIVATE()
    ON_WM_SETTINGCHANGE()
    ON_WM_CLOSE()
    ON_WM_INITMENUPOPUP()
    ON_WM_MENUSELECT()
    ON_WM_DRAWITEM()
    ON_WM_MEASUREITEM()
    ON_COMMAND(ID_WINDOW_LIST, OnWindowList)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

int CMDIFrameWndEx::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
    if ( CFrameWndBase< CMDIFrameWnd >::OnCreate( lpCreateStruct ) == -1 )
    {
        return -1;
    }

    VERIFY( m_wndMDIClient.SubclassWindow( m_hWndMDIClient ) );

    return 0;
}

void CMDIFrameWndEx::OnWindowList()
{
    CWindowListDialog dlg( &m_wndMDIClient, this );
    dlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMDIChildWndEx

IMPLEMENT_DYNCREATE( CMDIChildWndEx, CMDIChildWnd )

CMDIChildWndEx::CMDIChildWndEx()
{
}

CMDIChildWndEx::~CMDIChildWndEx()
{
}

/////////////////////////////////////////////////////////////////////////////
// CMDIChildWndEx message handlers

BEGIN_MESSAGE_MAP(CMDIChildWndEx, CMDIChildWnd)
    //{{AFX_MSG_MAP(CMDIChildWndEx)
    ON_WM_INITMENUPOPUP()
    ON_WM_DRAWITEM()
    ON_WM_MEASUREITEM()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()
