/////////////////////////////////////////////////////////////////////////////
// FrameWndEx.h: interface for the frame classes.
//
/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2002 by Nikolay Denisov. All rights reserved.
//
// This code is free for personal and commercial use, providing this 
// notice remains intact in the source files and all eventual changes are
// clearly marked with comments.
//
// You must obtain the author's consent before you can include this code
// in a software library.
//
// No warrantee of any kind, express or implied, is included with this
// software; use at your own risk, responsibility for damages (if any) to
// anyone resulting from the use of this software rests entirely with the
// user.
//
// Please email bug reports, bug fixes, enhancements, requests and
// comments to: acnick@mail.lanck.net
/////////////////////////////////////////////////////////////////////////////

#ifndef __FRAMEWNDEX_H__
#define __FRAMEWNDEX_H__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "BmpMenuOwnerWnd.h"
#include "Resource.h"
#include "MenuBar.h"
#include "SizableReBar.h"
#include "WinAppEx.h"

/////////////////////////////////////////////////////////////////////////////
// CFrameWndBase

template< class TBase >
class CFrameWndBase : public CBmpMenuOwnerWnd< TBase >
{
// Constructors
public:
    CFrameWndBase();
    ~CFrameWndBase();

// Attributes
public:
    CSizableReBar   m_wndReBar;
    CMenuBar        m_wndMenuBar;

// Operations
public:
    void ShowWindow( int nCmdShow, LPCTSTR lpszProfileName );

// Overrides
public:
    virtual BOOL LoadFrame( UINT nIDResource,
        DWORD dwDefaultStyle = WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE,
        CWnd* pParentWnd = 0, CCreateContext* pContext = 0 );

// Implementation data
protected:
    CString m_strProfileName;
    bool    m_bInPlace;

    static LPCTSTR  m_lpszFrameWndPlacementEntry;

// Message map functions
protected:
    afx_msg int OnCreate( LPCREATESTRUCT lpCreateStruct );
    afx_msg void OnSysCommand( UINT nID, LPARAM lParam );
    afx_msg LRESULT OnMenuChar( UINT nChar, UINT nFlags, CMenu* pMenu );
    afx_msg BOOL OnNcActivate( BOOL bActive );
    afx_msg void OnSettingChange( UINT uFlags, LPCTSTR lpszSection );
    afx_msg void OnClose();
    afx_msg void OnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu );
    afx_msg void OnMenuSelect( UINT nItemID, UINT nFlags, HMENU hSysMenu );
};

/////////////////////////////////////////////////////////////////////////////
// CFrameWndEx frame

class GUILIB_EXT_CLASS CFrameWndEx : public CFrameWndBase< CFrameWnd >
{
    DECLARE_DYNCREATE( CFrameWndEx )

// Constructors
public:
    CFrameWndEx();
    ~CFrameWndEx();

// Overrides
protected:
    virtual void DelayUpdateFrameMenu( HMENU hMenuAlt );
    virtual void OnUpdateFrameMenu( HMENU hMenuAlt );

// Generated message map functions
protected:
    //{{AFX_MSG(CFrameWndEx)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CMDIClientWndEx

class CMDIFrameWndEx;

class CMDIClientWndEx : public CWnd
{
    DECLARE_DYNCREATE( CMDIClientWndEx )

// Constructors
public:
    CMDIClientWndEx();
    ~CMDIClientWndEx();

// Implementation
protected:
    CMDIFrameWndEx* GetParentFrame() const;

// Implementation data
protected:
    HMENU m_hWindowMenu;

// Generated message map functions
protected:
    //{{AFX_MSG(CMDIClientWndEx)
    //}}AFX_MSG
    afx_msg LRESULT OnMDISetMenu( WPARAM wParam, LPARAM lParam );
    afx_msg LRESULT OnMDIRefreshMenu( WPARAM wParam, LPARAM lParam );
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CMDIFrameWndEx frame

class GUILIB_EXT_CLASS CMDIFrameWndEx : public CFrameWndBase< CMDIFrameWnd >
{
    DECLARE_DYNCREATE( CMDIFrameWndEx )

    friend CMDIClientWndEx;

// Constructors
public:
    CMDIFrameWndEx();
    ~CMDIFrameWndEx();

// Overrides
protected:
    virtual void DelayUpdateFrameMenu( HMENU hMenuAlt );
    virtual void OnUpdateFrameTitle( BOOL bAddToTitle );

// Implementation data
protected:
    CMDIClientWndEx m_wndMDIClient;

// Generated message map functions
protected:
    //{{AFX_MSG(CMDIFrameWndEx)
    afx_msg int OnCreate( LPCREATESTRUCT lpCreateStruct );
    afx_msg void OnWindowList();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CMDIChildWndEx frame

class GUILIB_EXT_CLASS CMDIChildWndEx : public CBmpMenuOwnerWnd< CMDIChildWnd >
{
    DECLARE_DYNCREATE( CMDIChildWndEx )

// Constructors
public:
    CMDIChildWndEx();
    ~CMDIChildWndEx();

// Generated message map functions
protected:
    //{{AFX_MSG(CMDIChildWndEx)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CFrameWndBase out-of-line functions

template< class TBase >
LPCTSTR CFrameWndBase< TBase >::m_lpszFrameWndPlacementEntry = _T("FrameWndPlacement");

template< class TBase >
CFrameWndBase< TBase >::CFrameWndBase() : m_bInPlace( false )
{
}

template< class TBase >
CFrameWndBase< TBase >::~CFrameWndBase()
{
}

template< class TBase >
void CFrameWndBase< TBase >::ShowWindow( int nCmdShow, LPCTSTR lpszProfileName )
{
    m_strProfileName = lpszProfileName;
    if ( !m_strProfileName.IsEmpty() )
    {
        WINDOWPLACEMENT* lpwndpl;
        UINT nBytes;

        if ( AfxGetApp()->GetProfileBinary( m_strProfileName,
                m_lpszFrameWndPlacementEntry, ( LPBYTE* )&lpwndpl, &nBytes ) )
        {
            CRect rcDesktop;
            GetDesktopWindow()->GetWindowRect( rcDesktop );

            // Only restore if window intersects the screen
            CRect rcTemp;
            if ( IntersectRect( rcTemp, &lpwndpl->rcNormalPosition, rcDesktop ) )
            {
                nCmdShow = ( lpwndpl->showCmd == SW_SHOWMINIMIZED ) ? SW_SHOWNORMAL : lpwndpl->showCmd;
                SetWindowPlacement( lpwndpl );
            }

            delete lpwndpl;
        }
    }

    CBmpMenuOwnerWnd< TBase >::ShowWindow( nCmdShow );
}

template< class TBase >
BOOL CFrameWndBase< TBase >::LoadFrame( UINT nIDResource, DWORD dwDefaultStyle,
                                        CWnd* pParentWnd, CCreateContext* pContext )
{
    if ( !TBase::LoadFrame( nIDResource, dwDefaultStyle, pParentWnd, pContext ) )
    {
        return FALSE;
    }

    VERIFY( m_wndMenuBar.SetMenu( ::GetMenu( m_hWnd ) ) );
    VERIFY( SetMenu( 0 ) );

    return TRUE;
}

template< class TBase >
int CFrameWndBase< TBase >::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
    if ( CBmpMenuOwnerWnd< TBase >::OnCreate( lpCreateStruct ) == -1 )
    {
        return -1;
    }

    if ( !m_wndReBar.Create( this, IDW_SIZABLEREBAR,
            WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN |
            CBRS_ALIGN_TOP | CBRS_SIZE_DYNAMIC ) )
    {
        return -1;
    }

    if ( !m_wndMenuBar.CreateEx( this,
            TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TRANSPARENT | TBSTYLE_CUSTOMERASE, // Toolbar styles
            WS_CHILD | WS_VISIBLE |                                             // Window styles
            CBRS_ALIGN_TOP | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_HIDE_INPLACE,    // Control bar styles
            CRect( 0, 0, 0, 0 ), IDW_MENUBAR ) )
    {
        return -1;
    }

    if ( !m_wndReBar.AddBar( &m_wndMenuBar, 0, 0, RBBS_FIXEDBMP ) )
    {
        return -1;
    }

    m_wndMenuBar.SetOwner( &m_wndReBar );
    m_wndMenuBar.UpdateMenuBar();

    return 0;
}

template< class TBase >
void CFrameWndBase< TBase >::OnSysCommand( UINT nID, LPARAM lParam )
{
    if ( !m_wndMenuBar.FrameOnSysCommand( nID, lParam ) )
    {
        CBmpMenuOwnerWnd< TBase >::OnSysCommand( nID, lParam );
    }
}

template< class TBase >
LRESULT CFrameWndBase< TBase >::OnMenuChar( UINT nChar, UINT nFlags, CMenu* pMenu )
{
    if ( m_wndMenuBar.FrameOnMenuChar( nChar, nFlags, pMenu ) )
    {
        return MAKELRESULT( 0, 1 );
    }

    return CBmpMenuOwnerWnd< TBase >::OnMenuChar( nChar, nFlags, pMenu );
}

template< class TBase >
BOOL CFrameWndBase< TBase >::OnNcActivate( BOOL bActive )
{
    CFrameWnd* pFrame = GetTopLevelFrame();
    ASSERT_VALID( pFrame );

    m_wndMenuBar.FrameOnNcActivate(
        ( bActive || ( pFrame->m_nFlags & WF_STAYACTIVE ) ) && pFrame->IsWindowEnabled() );

    return CBmpMenuOwnerWnd< TBase >::OnNcActivate( bActive );
}

template< class TBase >
void CFrameWndBase< TBase >::OnSettingChange( UINT uFlags, LPCTSTR lpszSection )
{
    CWinAppEx::GetInstance()->UpdateSystemParameters();    // reload cached metrics

    CBmpMenuOwnerWnd< TBase >::OnSettingChange( uFlags, lpszSection );
}

template< class TBase >
void CFrameWndBase< TBase >::OnClose()
{
    if ( m_lpfnCloseProc == 0 )
    {
        if ( !m_strProfileName.IsEmpty() )
        {
            WINDOWPLACEMENT wndpl;
            wndpl.length = sizeof( wndpl );

            if ( GetWindowPlacement( &wndpl ) )
            {
                AfxGetApp()->WriteProfileBinary( m_strProfileName,
                    m_lpszFrameWndPlacementEntry, ( LPBYTE )&wndpl, wndpl.length );
            }
        }
    }

    CBmpMenuOwnerWnd< TBase >::OnClose();
}

template< class TBase >
void CFrameWndBase< TBase >::OnInitMenuPopup( CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu )
{
    CBmpMenuOwnerWnd< TBase >::OnInitMenuPopup( pPopupMenu, nIndex, bSysMenu );

    m_wndMenuBar.FrameOnInitMenuPopup( pPopupMenu, nIndex, bSysMenu );
}

template< class TBase >
void CFrameWndBase< TBase >::OnMenuSelect( UINT nItemID, UINT nFlags, HMENU hSysMenu )
{
    CBmpMenuOwnerWnd< TBase >::OnMenuSelect( nItemID, nFlags, hSysMenu );

#if _MFC_VER == 0x0700
    m_wndMenuBar.FrameOnMenuSelect( nItemID, nFlags, ( ( CMenu* )hSysMenu )->GetSafeHmenu() );
#else
    m_wndMenuBar.FrameOnMenuSelect( nItemID, nFlags, hSysMenu );
#endif
}

/////////////////////////////////////////////////////////////////////////////
#endif  // !__FRAMEWNDEX_H__
