/**
 * @file Actuator.h
 * 
 * Definition of class Actuator
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#ifndef ACTUATOR_H_
#define ACTUATOR_H_

#include "SimObject.h"


/** Information about one actuatorport*/
struct ActuatorportData
{
  /** The minumum value*/
  double min;
  /** The maximum value*/
  double max;
  /** The current value*/
  double value;
};


/**
* @class Actuator
*
* An abstract class representing an actuator
*/
class Actuator : public virtual SimObject
{
public:
  /** Returns a string describing the kind of object
  * @return The kind
  */
  virtual std::string getKind() const {return "actuator";}

  /** Sets the value of one actuatorport
  * @param value The value
  * @param port The port
  */
  virtual void setValue(double value, int port) = 0;

  /** Let the actuator do what it is supposed to do
   * @param initial Is this the initial step?
   */
  virtual void act(bool initial = false) = 0;
};

#endif //ACTUATOR_H_

/*
 * $Log: Actuator.h,v $
 * Revision 1.2  2003/12/09 13:40:49  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/12/09 12:38:25  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/09/28 14:50:04  roefer
 * Planes changed, initialValue for joints added
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */