/**
 * @file Bumper.cpp
 * 
 * Implementation of class Bumper
 *
 * @author <A href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</A>
 */ 

#include "Bumper.h"
#include "Sensorport.h"


Bumper::Bumper()
{
  value = 0.0;
}

void Bumper::addToLists(std::vector<Sensorport*>& sensorportList,
                        std::vector<Actuatorport*>& actuatorportList,
                        std::vector<Actuator*>& actuatorList) 
{
  Sensorport* bumperPort = new Sensorport("collision", 0, boolSensor, 
                                          this, 0.0, 1.0);
  sensorportList.push_back(bumperPort);
}

void Bumper::addToDescriptions(std::vector<ObjectDescription>& objectDescriptionTree,
                               int depth) 
{
  Sensor::addToDescriptions(objectDescriptionTree, depth);  
  ObjectDescription sensorportDesc;
  sensorportDesc.name = "collision";
  sensorportDesc.fullName = fullName + ".collision";
  sensorportDesc.depth = depth + 1;
  sensorportDesc.type = OBJECT_TYPE_SENSORPORT;
  objectDescriptionTree.push_back(sensorportDesc);
}

void Bumper::computeValue(bool& value, int portId)
{
  if(simulationStep > lastComputationStep)
  {
    this->value = checkCollisionWithScene();
    lastComputationStep = simulationStep;
  }
  value = this->value;
}

SimObject* Bumper::clone() const 
{
  Bumper* newBumper = new Bumper();
  newBumper->setName(name);
  newBumper->setFullName(fullName);
  newBumper->setPosition(position);
  newBumper->rotation = rotation;
  newBumper->parentNode = parentNode;
  newBumper->deactivatedChildNode = deactivatedChildNode;
  newBumper->deactivatedChildNodeSuccessor = deactivatedChildNodeSuccessor;
  newBumper->intersectionSphereRadius = intersectionSphereRadius;
  std::list<SimObject*>::const_iterator pos;
  for(pos = childNodes.begin(); pos != childNodes.end(); ++pos)
  {
    SimObject* childNode = (*pos)->clone();
    newBumper->addChildNode(childNode, false);
  }
  SimObject* newObject = newBumper;
  return newObject;
}

/*
 * $Log: Bumper.cpp,v $
 * Revision 1.2  2003/12/09 13:40:49  roefer
 * href attribute corrected
 *
 * Revision 1.5  2003/12/09 12:38:25  roefer
 * href attribute corrected
 *
 * Revision 1.4  2003/10/18 11:25:44  tim
 * - fixed intersection tests
 * - faster intersection test
 * - reimplementation of SimGeometry
 * - added portId for sensor calls
 * - finished sensor interfaces for joint and movableObject
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */
