#include "Debug.h"
#include "Platform/DebugOutput.h"
#include "SimMath.h"
#include "APIDatatypes.h"

void DOut::print(const char* s)
{
  printString(s);
}

DOut& DOut::operator<<(const Vector3d& v)
{
  *(this)<<"( "<<v.v[0]<<" | "<<v.v[1]<<" | "<<v.v[2]<<" )"<<"\n";
  return (*this);
}

DOut& DOut::operator<<(const Matrix3d& m)
{
  *(this)<<m.col[0].v[0]<<"  "<<m.col[1].v[0]<<"  "<<m.col[2].v[0]<<"\n";
  *(this)<<m.col[0].v[1]<<"  "<<m.col[1].v[1]<<"  "<<m.col[2].v[1]<<"\n";
  *(this)<<m.col[0].v[2]<<"  "<<m.col[1].v[2]<<"  "<<m.col[2].v[2]<<"\n";
  return (*this);
}

DOut& DOut::operator<<(const ErrorDescription& e)
{
  return (*this);
}

/*
 * $Log: Debug.cpp,v $
 * Revision 1.2  2003/12/09 13:40:50  roefer
 * href attribute corrected
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */