#ifndef SIMROBOT_DEBUG_H_
#define SIMROBOT_DEBUG_H_

#include <string>

class Matrix3d;
class Vector3d;
class ErrorDescription;


class DOut
{
private:
  char conversionBuffer[200];
 
public:
  DOut& operator<<(double d)
  {
    sprintf(&conversionBuffer[0],"%f",d);
    print(&conversionBuffer[0]);
    return (*this);
  }

  DOut& operator<<(int i)
  {
    sprintf(&conversionBuffer[0],"%d",i);
    print(&conversionBuffer[0]);
    return (*this);
  }

  DOut& operator<<(unsigned int u)
  {
    sprintf(&conversionBuffer[0],"%u",u);
    print(&conversionBuffer[0]);
    return (*this);
  }

  DOut& operator<<(bool b)
  {
    if(b)
      print("true");
    else
      print("false");
  }

  DOut& operator<<(const char* c)
  {
    print(c);
    return (*this);
  }

  DOut& operator<<(const std::string& s)
  {
    print(s.c_str());
    return (*this);
  }


  DOut& operator<<(const Vector3d& v);
  DOut& operator<<(const Matrix3d& m);
  DOut& operator<<(const ErrorDescription& e);

  void print(const char* s);

  static DOut& getDebugObject()
  {
    static DOut instance;
    return instance;
  }

};


#define DOUT(expression)
//DOut::getDebugObject() << expression;

#endif //SIMROBOT_DEBUG_H_

/*
 * $Log: Debug.h,v $
 * Revision 1.2  2003/12/09 13:40:50  roefer
 * href attribute corrected
 *
 * Revision 1.3  2003/09/08 22:32:07  tim
 * - removed files
 * - added some doxygen documentation
 * - added some const qualifiers
 * - partial code clean-up
 * - minor code changes
 * - remove __ from guards (__ should only be used by compiler)
 *
 * Revision 1.2  2003/09/04 13:34:21  tim
 * - better parsing of numbers
 * - fixed macro bug
 * - better integration of macros in the object tree
 * - added getObjectReference() to Simulation
 * - faster object look-up in Simulation
 * - added changed log
 *
 */



