/**
* @file RobotVertices.cpp
*
* Implementation of struct RobotVertices
* 
* @author Uwe Dffert
*/

#include "RobotVertices.h"
#include "Tools/Math/Common.h"

RobotVertices::RobotVertices(const RobotDimensions& r):bodyTilt(0),bodyRoll(0),neckHeight(0),frameNumber(0)
{
  neck=Vector3<double>(0,0,r.lowerForeLegLength+r.upperLegLength+r.neckToLegsLengthZ);

  //order is the same as in Kinematics::LegIndex{fr,fl,hr,hl}:
  footPosition[0]=Vector3<double>(-r.neckToLegsLengthX,-r.bodyWidth/2,0);
  footPosition[1]=Vector3<double>(-r.neckToLegsLengthX,r.bodyWidth/2,0);
  footPosition[2]=Vector3<double>(-r.neckToLegsLengthX-r.lengthBetweenLegs,-r.bodyWidth/2,0);
  footPosition[3]=Vector3<double>(-r.neckToLegsLengthX-r.lengthBetweenLegs,r.bodyWidth/2,0);

  kneePosition[0]=footPosition[0]+Vector3<double>(r.upperLegLengthX,0,cos(r.zeroFrontKneeArc-r.zeroShoulderArc)*r.lowerForeLegLength);
  kneePosition[1]=footPosition[1]+Vector3<double>(r.upperLegLengthX,0,cos(r.zeroFrontKneeArc-r.zeroShoulderArc)*r.lowerForeLegLength);
  kneePosition[2]=footPosition[2]+Vector3<double>(-r.upperLegLengthX,0,cos(r.zeroHindKneeArc-r.zeroShoulderArc)*r.lowerHindLegLength);
  kneePosition[3]=footPosition[3]+Vector3<double>(-r.upperLegLengthX,0,cos(r.zeroHindKneeArc-r.zeroShoulderArc)*r.lowerHindLegLength);

  shoulderPosition[0]=kneePosition[0]+Vector3<double>(-r.upperLegLengthX,0,cos(r.zeroShoulderArc)*r.upperLegLength);
  shoulderPosition[1]=kneePosition[1]+Vector3<double>(-r.upperLegLengthX,0,cos(r.zeroShoulderArc)*r.upperLegLength);
  shoulderPosition[2]=kneePosition[2]+Vector3<double>(r.upperLegLengthX,0,cos(r.zeroShoulderArc)*r.upperLegLength);
  shoulderPosition[3]=kneePosition[3]+Vector3<double>(r.upperLegLengthX,0,cos(r.zeroShoulderArc)*r.upperLegLength);
}

In& operator>>(In& stream,RobotVertices& robotVertices)
{
  stream.read(&robotVertices,sizeof(robotVertices));
  return stream;
}
 
Out& operator<<(Out& stream, const RobotVertices& robotVertices)
{
  stream.write(&robotVertices,sizeof(robotVertices));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: RobotVertices.cpp,v $
 * Revision 1.5  2004/03/20 09:55:28  roefer
 * Preparation for improved odometry
 *
 * Revision 1.4  2004/01/28 21:55:50  roefer
 * RobotDimensions revised
 *
 * Revision 1.3  2004/01/01 10:58:51  roefer
 * RobotDimensions are in a class now
 *
 * Revision 1.2  2003/12/02 18:14:34  dueffert
 * correction values named
 *
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1  2003/09/26 11:40:40  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1  2003/09/15 20:37:07  dueffert
 * new DataType added
 *
 */
