/**
 * @file CollectedBeliefs.h
 * 
 * Declaration of class CollectedBeliefs
 * @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
 */ 

#ifndef __CollectedBeliefs_h_
#define __CollectedBeliefs_h_

#include "Modules/BehaviorControl/BehaviorControl.h"
#include "Tools/Player.h"
#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/RobotPose.h"
#include "RateableOptions.h"
#include "Tools/SlidingAverageValue.h"


/**
 *  The class contains information on how the robot senses his
 *  enviroment.
 */
class SingleBeliefs
{
public:
  /** Constructor */
  SingleBeliefs();

  /** Destructor */
  ~SingleBeliefs();

  /** Rating on all "options" */
  SlidingAverageValue ratedOptions[RateableOptions::numOfOptions];

  /** The time when the package was sent */
  unsigned long timeStamp;

  /** the timeStamps from the other SingleBeliefs
	  * can be used to detect single sided Communication failure
		* based upon suggestion from Jrn (see IRC Log 6.12.2003)
		*
		* zunchst lasse ich das mal raus... mal sehen, ob wir das
		* wirklich brauchen
	  */
  //unsigned long lastUpdateFromTeamMember[3];

	RateableOptions::OptionID getBestOptionInOptionClass(RateableOptions::OptionClassID id);

private:

  RateableOptions::OptionID lastBestOpt[RateableOptions::numOfOptionClasses];

};

/**
 * Streaming operator that reads a SingleBeliefs from a stream.
 * @param stream The stream from which is read.
 * @param singleBeliefs The SingleBeliefs object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SingleBeliefs& singleBeliefs);

/**
 * Streaming operator that writes a SingleBeliefs to a stream.
 * @param stream The stream to write on.
 * @param singleBeliefs The SingleBeliefs object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream,SingleBeliefs& singleBeliefs);



/**
 *  This class contains the PlayerPoses of all detected robots.
 */
class CollectedBeliefs : public BehaviorControlInterfaces
{
public:
  /** Constructor */
  CollectedBeliefs(const BehaviorControlInterfaces& interfaces);

  /** Destructor */
  ~CollectedBeliefs();

  /** 
   * The four SingleBeliefs of the team members.
   * To be adressed by (int)Player::playerNumber
   */
  SingleBeliefs singleBeliefs[Player::numOfPlayerNumbers];

  /**
   *  This method updates recently received SingleBeliefs.
	 *  btw: the "own" SingleBeliefs is singleBeliefs[(int)(getPlayer().getPlayerRole())]
	 */
	void update();


  /**
   *  This method broadcasts the own SingleBeliefs to the other robots.
	 *  btw: the "own" SingleBeliefs is singleBeliefs[(int)(getPlayer().getPlayerRole())]
	 */
	void broadcast();

  /**
   *  This method triggers all SingleBeliefs.rateOptions
	 */
	void trigger();


};

/**
 * Streaming operator that reads a CollectedBeliefs from a stream.
 * @param stream The stream from which is read.
 * @param collectedBeliefs The CollectedBeliefs object.
 * @return The stream.
 */ 
In& operator>>(In& stream,CollectedBeliefs& collectedBeliefs);
 
/**
 * Streaming operator that writes a CollectedBeliefs to a stream.
 * @param stream The stream to write on.
 * @param collectedBeliefs The CollectedBeliefs object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const CollectedBeliefs& collectedBeliefs);


#endif //__CollectedBeliefs_h_

/*
 * Change log :
 * 
 * $Log: CollectedBeliefs.h,v $
 * Revision 1.12  2004/04/08 17:14:27  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.12  2004/03/21 04:36:06  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.11  2004/03/08 01:07:19  roefer
 * Interfaces should be const
 *
 * Revision 1.10  2004/02/05 09:26:23  kerdels
 * modified use of threshold
 *
 * Revision 1.9  2004/02/03 13:19:49  spranger
 * renamed all references to  class BallPosition to BallModel
 *
 * Revision 1.8  2003/12/28 23:00:12  kerdels
 * tactic chooser berarbeitet
 *
 * Revision 1.7  2003/12/21 15:42:31  kerdels
 * getBestOptionInOptionClass erweitert
 *
 * Revision 1.6  2003/12/18 19:50:13  kerdels
 * getBestOptionInOptionClass methode gebastelt
 *
 * Revision 1.5  2003/12/17 20:09:59  kerdels
 * BehaviorTeamMessage um eine Eigenschaft ratedOptions erweitert,
 * CollectedBeliefs.update() und .broadcast() implementiert.
 *
 * Revision 1.4  2003/12/17 16:10:40  kerdels
 * Single/ColelctedBeliefs von unntigem Ballast befreit ;-)
 *
 * Revision 1.3  2003/12/11 18:28:21  kerdels
 * DTT Framework fertiggestellt.
 *
 * Revision 1.2  2003/12/11 16:22:20  kerdels
 * Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
 *
 * Revision 1.1  2003/12/10 20:46:11  kerdels
 * CollectedBeliefs entfernt
 *
 * Revision 1.3  2003/12/07 14:59:54  kindler
 * Changelog keyword added.
 *
 *
 */
