/**
* @file GlobalAnalyser.h
* 
* This file contains a generic class for global analysing.
* @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
*/

#ifndef __GlobalAnalyser_h_
#define __GlobalAnalyser_h_

#include "Modules/BehaviorControl/BehaviorControl.h"

/**
* @class GlobalAnalyser 
*
* The Base class for global analysis
*
* It is the task of global analysis to weight TacticEntries in a
* situation-dependend manner.
*/
class GlobalAnalyser :  public BehaviorControlInterfaces
{
protected:

public:

  /**
   * Constructor.
   * @param interfaces The parameters of the GlobalAnalyser module.
   */
  GlobalAnalyser(const BehaviorControlInterfaces& interfaces)
    : BehaviorControlInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~GlobalAnalyser() {}


	/** This method should be implemented by descendants */
	virtual void update() = 0;

	/** This method should be implemented by descendants */
	virtual double getWeight(RateableOptions::TacticEntryTypeID tacticEntryType) = 0;

};

#endif // __GlobalAnalyser_h_

/*
 * Change log :
 * $Log: GlobalAnalyser.h,v $
 * Revision 1.2  2004/03/08 01:07:19  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/12/29 12:26:27  kerdels
 * global analysis hinzugefgt
 *
 *
 */
