/**
* @file OptionRating.h
* 
* This file contains a generic class for Option Rating.
* @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
*/

#ifndef __OptionRating_h_
#define __OptionRating_h_

#include "Modules/BehaviorControl/BehaviorControl.h"
#include "CollectedBeliefs.h"
#include "ChooserRaterInterfaces.h"

/**
* @class OptionRating 
*
* The Base class for option rating
*
* It is the task of option rating to rate all avaible options.
*/
class OptionRating :  public BehaviorControlInterfaces
{
protected:
  
  CollectedBeliefs& collectedBeliefs;
  
  ChooserRaterInterfaces& chooserRaterInterfaces;
  
public:
  
/**
* Constructor.
* @param interfaces The parameters of the OptionRating module.
* @param collectedBeliefs The collected-Beliefs to work on.
* @param chooserRaterInterfaces We want to talk to the Tactic-Chooser.
* @param kickInProgress  just a little hack for option rating
  */
  OptionRating(const BehaviorControlInterfaces& interfaces,
    CollectedBeliefs& collectedBeliefs,
    ChooserRaterInterfaces& chooserRaterInterfaces,
    bool& kickInProgress
    )
    : BehaviorControlInterfaces(interfaces),
		  collectedBeliefs(collectedBeliefs),
      chooserRaterInterfaces(chooserRaterInterfaces),
      kickInProgress(kickInProgress)
  {}
  
  /** Destructor */
  virtual ~OptionRating() {}
  
  
  /** This method should be implemented by descendants */
  virtual void rateOptions() = 0;
  
  /** hack for optionRating */
  bool& kickInProgress;
};

#endif // __OptionRating_h_

/*
* Change log :
* $Log: OptionRating.h,v $
* Revision 1.6  2004/04/14 06:37:17  loetzsch
* removed the hack "kickInProgress" from the BehaviorControlInterfaces
*
* Revision 1.5  2004/03/08 01:07:19  roefer
* Interfaces should be const
*
* Revision 1.4  2004/03/02 22:28:46  huelsbusch
* Added missing doxygen comments
*
* Revision 1.3  2004/01/29 21:33:28  kerdels
* added turn-for-ball Option to DTT,
* added link between TacticChooser and OptionRating
*
* Revision 1.2  2003/12/11 16:22:20  kerdels
* Die DynamicTeamTactic neu strukturiert und ins MSH2004 Behavior integriert..
*
* Revision 1.1  2003/12/10 20:46:12  kerdels
* CollectedBeliefs entfernt
*
* Revision 1.3  2003/12/07 15:21:08  kindler
* tabs to spaces, doxygen comment corrected.
*
* Revision 1.2  2003/12/07 15:03:43  kindler
* Changelog keyword added.
*
*/
