/**
 * @file TacticEntry.cpp
 * 
 * Declaration of class TacticEntry
 * @author <A href=mailto:b@tchman.de>Mathias Hlsbusch</A>
 * @author <A href=mailto:frank.rossdeutscher@uni-dortmund.de>Frank Rossdeutscher</A>
 */ 

#include "TacticEntry.h"
#include "Platform/GTAssert.h"


TacticEntry::TacticEntry() 
{
	followingEntryCount = 0;
  sprintf(name,"noname");
}

TacticEntry::TacticEntry(int folEntCount) 
{
	followingEntryCount = folEntCount;
 	if (followingEntryCount > 0) {
	  followingEntrys       = new int[followingEntryCount];
	  followingEntryWeights = new double[followingEntryCount];
  }
  sprintf(name,"noname");
}

TacticEntry::~TacticEntry() 
{
	if (followingEntryCount > 0) {
		delete[] followingEntrys;
		delete[] followingEntryWeights;
	}
}

void TacticEntry::setFollowingEntryCount(int count)
{
	if (followingEntryCount > 0) {
		delete[] followingEntrys;
		delete[] followingEntryWeights;
	}
	followingEntryCount = count;
 	if (followingEntryCount > 0) {
	  followingEntrys       = new int[followingEntryCount];
	  followingEntryWeights = new double[followingEntryCount];
  }
}

/*
In& operator>>(In& stream,TacticEntry& tacticEntry)
{
  stream.read(&tacticEntry,sizeof(TacticEntry));
  return stream;
}

Out& operator<<(Out& stream, const TacticEntry& tacticEntry)
{
  stream.write(&tacticEntry,sizeof(TacticEntry));
  return stream;
} 
*/



TacticEntryArray::TacticEntryArray() 
{
	entryCount = 0;
}

TacticEntryArray::TacticEntryArray(int count) 
{
	entryCount = count;
  // creating new entries
 	if (entryCount > 0)
    entrys = new TacticEntry[entryCount];
}

TacticEntryArray::~TacticEntryArray() 
{
	if (entryCount > 0)
    delete[] entrys;
}

void TacticEntryArray::setEntryCount(int count)
{
	if (entryCount > 0)
    delete[] entrys;
	entryCount = count;
  // creating new entries
 	if (entryCount > 0)
    entrys = new TacticEntry[entryCount];
}



In& operator>>(In& stream,TacticEntryArray& tacticEntryArray)
{
  unsigned int chunkid;
  int chunksize;
  int entryIdx      = -1;
  int readPlayerNum =  0;
  int readGANum     =  0;
  char* tmpstr = new char[50];
  while (!stream.eof()) {
    stream >> chunkid;
    stream >> chunksize;

    switch (chunkid) {

      case 0x00414554 : // "TEA\0" TacticEntryArray
      {
        // deleting old entries
      	if (tacticEntryArray.entryCount > 0)
          delete[] tacticEntryArray.entrys;

        // reading the number of entries
        stream >> tacticEntryArray.entryCount;

        // reading the number of playerNumbers
        stream >> readPlayerNum;

        // creating new entries
      	if (tacticEntryArray.entryCount > 0)
          tacticEntryArray.entrys = new TacticEntry[tacticEntryArray.entryCount];

        // setting entrie "pointer" before first entry
        entryIdx = -1;
      } break;

      case 0x00544E45 : // "ENT\0" Entry
      {
        ++entryIdx; // point to the next tacticEntry
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
      } break;

      case 0x00504F4E : // "NOP\0" neededOptions
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i;
        for (i = 0; i < readPlayerNum; ++i)
        {
          stream >> tmpstr;
          if (i < Player::numOfPlayerNumbers)
            tacticEntryArray.entrys[entryIdx].neededOptions[i] =
                                                   RateableOptions::getOptionID(tmpstr);
        }
        // if we read not enough entries fill the rest with doNothing
        for (i = readPlayerNum; i < Player::numOfPlayerNumbers; ++i)
          tacticEntryArray.entrys[entryIdx].neededOptions[i] =
                                                   RateableOptions::doNothing;

        // generating isOptionClass Array
        for (i = 0; i < Player::numOfPlayerNumbers; ++i)
          tacticEntryArray.entrys[entryIdx].isOptionClass[i] =
            RateableOptions::isOptionClass(
                               tacticEntryArray.entrys[entryIdx].neededOptions[i]);
      } break;

      case 0x00474441 : // "ADG\0" allowedDogs
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i,j;
        bool tmpbool;
        for (i = 0; i < readPlayerNum; ++i)
          for (j = 0; j < readPlayerNum; ++j)
          {
            stream.read(&tmpbool,sizeof(bool));
            if ((i < Player::numOfPlayerNumbers) && (j < Player::numOfPlayerNumbers))
              tacticEntryArray.entrys[entryIdx].allowedDogs[i][j] = tmpbool;
          }
        // if we read not enough entries fill the rest with true
        for (i = 0; i < Player::numOfPlayerNumbers; ++i)
          for (j = 0; j < Player::numOfPlayerNumbers; ++j)
            if ((i >= readPlayerNum) || (j >= readPlayerNum))
              tacticEntryArray.entrys[entryIdx].allowedDogs[i][j] = true;
      } break;

      case 0x00544757 : // "WGT\0" weight
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        stream >> tacticEntryArray.entrys[entryIdx].weight;
      } break;

      case 0x0047574F : // "OWG\0" optionWeights
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i;
        double tmpdouble;
        for (i = 0; i < readPlayerNum; ++i)
        {
          stream >> tmpdouble;
          if (i < Player::numOfPlayerNumbers)
            tacticEntryArray.entrys[entryIdx].optionWeights[i] = tmpdouble;
        }
        // if we read not enough entries fill the rest with doNothing
        for (i = readPlayerNum; i < Player::numOfPlayerNumbers; ++i)
          tacticEntryArray.entrys[entryIdx].optionWeights[i] = 0.0;
      } break;

      case 0x0056584D : // "MXV\0" maxVal
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        stream >> tacticEntryArray.entrys[entryIdx].maxVal;
      } break;

      case 0x00434546 : // "FEC\0" followingEntryCount
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
      	if (tacticEntryArray.entrys[entryIdx].followingEntryCount > 0) {
  		    delete[] tacticEntryArray.entrys[entryIdx].followingEntrys;
		      delete[] tacticEntryArray.entrys[entryIdx].followingEntryWeights;
        }
        stream >> tacticEntryArray.entrys[entryIdx].followingEntryCount;
      	if (tacticEntryArray.entrys[entryIdx].followingEntryCount > 0) {
	      	tacticEntryArray.entrys[entryIdx].followingEntrys =
            new int[tacticEntryArray.entrys[entryIdx].followingEntryCount];
	      	tacticEntryArray.entrys[entryIdx].followingEntryWeights =
            new double[tacticEntryArray.entrys[entryIdx].followingEntryCount];
        }
      } break;

      case 0x004E4546 : // "FEN\0" followingEntrys
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i;
        for (i = 0; i < tacticEntryArray.entrys[entryIdx].followingEntryCount; ++i)
          stream >> tacticEntryArray.entrys[entryIdx].followingEntrys[i];
      } break;

      case 0x00574546 : // "FEW\0" followingEntryWeights
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i;
        for (i = 0; i < tacticEntryArray.entrys[entryIdx].followingEntryCount; ++i)
          stream >> tacticEntryArray.entrys[entryIdx].followingEntryWeights[i];
      } break;

      case 0x00434147 : // "GAC\0" globalAnalysersCount
      {
        stream >> readGANum;
      } break;

      case 0x00494147 : // "GAI\0" globalAnalysersInfo
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        int i,tmpint;
        for (i = 0; i < readGANum; ++i)
        {
          stream >> tmpint;
          if (i < RateableOptions::numOfGlobalAnalysers)
            tacticEntryArray.entrys[entryIdx].globalAnalysersInfo[i] =
              (RateableOptions::TacticEntryTypeID)tmpint;
        }
        // if we read not enough entries fill the rest with 0
        for (i = readGANum; i < RateableOptions::numOfGlobalAnalysers; ++i)
          tacticEntryArray.entrys[entryIdx].globalAnalysersInfo[i] =
  RateableOptions::getGlobalAnalyserNeutralTETID((RateableOptions::GlobalAnalyserID)i);

      } break;

      case 0x004D414E : // "NAM\0" name
      {
        ASSERT((entryIdx < tacticEntryArray.entryCount) && (entryIdx >= 0));
        stream >> tacticEntryArray.entrys[entryIdx].name;
      } break;


      default :
      {
        stream.skip(chunksize); 
      }

    } // switch
  } // while

  delete[] tmpstr;

  return stream;
}

Out& operator<<(Out& stream, const TacticEntryArray& tacticEntryArray)
{
  stream << (unsigned int) 0x00414554;            // "TEA\0"
  stream << (int)(2 * sizeof(int));               // "size of chunk"
	
  // writing the number of entries
  stream << tacticEntryArray.entryCount;
  
  // writing the number of playerNumbers
  stream << (int)(Player::numOfPlayerNumbers);

	// writing the entries ..
  for (int i = 0; i < tacticEntryArray.entryCount; ++i) {
    int j,k,tmp;

    stream << (unsigned int) 0x00544E45;                       // "ENT\0" Entry
    stream << (int) 0;                                         // "size of chunk"
  
    stream << (unsigned int) 0x00504F4E;                       // "NOP\0" neededOptions
    tmp = Player::numOfPlayerNumbers * 4;                      // die strings werden mit einem fhrenden int abgespeichert
    for (j = 0; j < Player::numOfPlayerNumbers; ++j)           
      tmp += strlen(RateableOptions::getOptionName(
                                       tacticEntryArray.entrys[i].neededOptions[j]));
    stream << tmp;                                             // "size of chunk"

    for (j = 0; j < Player::numOfPlayerNumbers; ++j) 
      stream << RateableOptions::getOptionName(
                                   tacticEntryArray.entrys[i].neededOptions[j]);
    
    stream << (unsigned int) 0x00474441;                       // "ADG\0" allowedDogs
    stream << (int)((Player::numOfPlayerNumbers*
                     Player::numOfPlayerNumbers ) * sizeof(bool)); // "size of chunk"

    // there are some warnings when using streaming ops for bool, so we use the
    // read/write methods
    for (j = 0; j < Player::numOfPlayerNumbers; ++j) 
      for (k = 0; k < Player::numOfPlayerNumbers; ++k) 
        stream.write(&(tacticEntryArray.entrys[i].allowedDogs[j][k]),sizeof(bool));

    stream << (unsigned int) 0x00544757;                       // "WGT\0" weight
    stream << (int)(sizeof(double));                           // "size of chunk"
    stream << tacticEntryArray.entrys[i].weight;

    stream << (unsigned int) 0x0047574F;                          // "OWG\0" optionWeights
    stream << (int)(Player::numOfPlayerNumbers * sizeof(double)); // "size of chunk"

    for (j = 0; j < Player::numOfPlayerNumbers; ++j) 
      stream << tacticEntryArray.entrys[i].optionWeights[j];

    stream << (unsigned int) 0x0056584D;                       // "MXV\0" maxVal
    stream << (int)(sizeof(double));                           // "size of chunk"
    stream << tacticEntryArray.entrys[i].maxVal;

    stream << (unsigned int) 0x00434546;                       // "FEC\0" followingOptionCount
    stream << (int)(sizeof(int));                              // "size of chunk"
    stream << tacticEntryArray.entrys[i].followingEntryCount;

    stream << (unsigned int) 0x004E4546;                       // "FEN\0" followingEntries
    stream << (int)(tacticEntryArray.entrys[i].followingEntryCount * sizeof(int));

    for (j = 0; j < tacticEntryArray.entrys[i].followingEntryCount; ++j) 
      stream << tacticEntryArray.entrys[i].followingEntrys[j];
    
    stream << (unsigned int) 0x00574546;                          // "FEW\0" optionWeights
    stream << (int)(tacticEntryArray.entrys[i].followingEntryCount * sizeof(double)); // "size of chunk"

    for (j = 0; j < tacticEntryArray.entrys[i].followingEntryCount; ++j) 
      stream << tacticEntryArray.entrys[i].followingEntryWeights[j];

    stream << (unsigned int) 0x00434147;                       // "GAC\0" globalAnalysersCount
    stream << (int)(sizeof(int));                              // "size of chunk"
    stream << RateableOptions::numOfGlobalAnalysers;

    stream << (unsigned int) 0x00494147;                       // "GAI\0" globalAnalysersInfo
    stream << (int)(RateableOptions::numOfGlobalAnalysers * sizeof(int)); // "size of chunk"

    for (j = 0; j < RateableOptions::numOfGlobalAnalysers; ++j) 
      stream << tacticEntryArray.entrys[i].globalAnalysersInfo[j];

    stream << (unsigned int) 0x004D414E;                       // "NAM\0" name
    tmp = 4 + strlen(tacticEntryArray.entrys[i].name);         // die strings werden mit einem fhrenden int abgespeichert
    stream << tmp;                                             // "size of chunk"

    stream << tacticEntryArray.entrys[i].name;

  }


  return stream;
} 

/*
 * Change log :
 * $Log: TacticEntry.cpp,v $
 * Revision 1.7  2004/01/19 20:13:08  kerdels
 * added name capability to tacticentrys
 *
 * Revision 1.6  2004/01/04 01:00:47  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.5  2004/01/01 00:03:25  kerdels
 * tacticEntryArray Streaming berarbeitet
 *
 * Revision 1.4  2003/12/29 21:35:12  kerdels
 * tactics beispiel hinzugefgt,
 * laden aus datei im tacticchooser
 *
 * Revision 1.3  2003/12/17 23:58:06  huelsbusch
 * startet work on option-choosing
 *
 * Revision 1.2  2003/12/13 13:21:38  kerdels
 * tacticEntry debugged
 *
 * Revision 1.1  2003/12/13 11:44:26  rossdeutscher
 * TacticEntry implementiert und inc repository gebaut.
 *
 *
 */

