/**
 * @file TacticEntry.h
 * 
 * Declaration of class TacticEntry
 * @author <A href=mailto:b@tchman.de>Mathias Hlsbusch</A>
 * @author <A href=mailto:frank.rossdeutscher@uni-dortmund.de>Frank Rossdeutscher</A>
 */ 

#ifndef __TacticEntry_h_
#define __TacticEntry_h_

#include "Tools/Player.h"
#include "RateableOptions.h"


/**
 *  The class contains the information needed for one TacticEntry
 */
class TacticEntry
{
public:

  /** Constructor */
  TacticEntry();

  /** Constructor */
  TacticEntry(int folEntCount);

  /** Destructor */
  ~TacticEntry();

 /**
  * .An Array with up to 4 options that are needed for one entry
  */
  int neededOptions[Player::numOfPlayerNumbers];

 /**
  * .Which dogs are allowed to do this option ?
  *  This is basically a flag array.
  *  eg:
  *  01111 means that all dogs are allowed
  *  01110 means that dog #1 is not allowed for this option.
  *  So ( (allowedDogs[dognum] & (1 << dognum)) > 0 ) should be TRUE 
  *  if Dog #dognum is allowed for option #neededOptions[dognum]. But have a look in
  *  Player.h. If the playerNumber-enum changes, this test may cause trouble. 
  *  
  *  forget about this shifting-stuff .. an array of bool does the same, 
  *  but without all this enum-trusting ;)
  *  use: allowedDogs[#dog][#option]
  */
  bool allowedDogs[Player::numOfPlayerNumbers][Player::numOfPlayerNumbers];

 /**
  * .is one Option a option-class ?? .. 
  *  we dont need this yet, but we will be happy to have this *g*
  */
  
  bool isOptionClass[Player::numOfPlayerNumbers];

 /**
  * .The TacticEntry itself needs a weight
  */
  double weight;


 /**
  * .Each option needs one weight. So here they are
  */
  double optionWeights[Player::numOfPlayerNumbers];


 /**
  * .What ist the maximum value this TacticEntry can reach
  *  This data can be uses to skip TacticEntrys while searching
  *  the best matching TacticEntry.
  */
  double maxVal;

 /**
  *  How many followingEntrys are there ?
  */
	int followingEntryCount;

 /**
  *  Which TacticEntrys should be preferred after choosing this TacticEntry ?
  */
  int* followingEntrys;

 /**
  *  How would you like to weight your preferred followingEntrys ? .
  */
  double* followingEntryWeights;

 /**
  * Information for GlobalAnalysers. Each Analyser can store an integer here
  * to identify the Class of TacticEntry, e.g. is an offensive TacticEntry..
  */
	RateableOptions::TacticEntryTypeID globalAnalysersInfo[RateableOptions::numOfGlobalAnalysers];


  void setFollowingEntryCount(int count);

 /**
  *  name of the TacticEntry
  */
  char name[50];
};


/**
 * Streaming operator that reads a TacticEntry from a stream.
 * @param stream The stream from which is read.
 * @param tacticEntry the TacticEntry object.
 * @return The stream.
 */ 
//In& operator>>(In& stream,TacticEntry& tacticEntry);
 
/**
 * Streaming operator that writes a TacticEntry to a stream.
 * @param stream The stream to write on.
 * @param tacticEntry The TacticEntry object.
 * @return The stream.
 */ 
//Out& operator<<(Out& stream, const TacticEntry& tacticEntry);


/**
 *  The class contains an array of TacticEntrys
 */
class TacticEntryArray
{
public:
  /** Constructor */
  TacticEntryArray();

  /** Constructor with count*/
  TacticEntryArray(int count);

  /** Destructor */
  ~TacticEntryArray();

	int entryCount;

  TacticEntry* entrys;

  // TacticEntry lastChoice; ???

  void setEntryCount(int count);


};


/**
 * Streaming operator that reads a TacticEntryArray from a stream.
 * @param stream The stream from which is read.
 * @param tacticEntryArray the TacticEntryArray object.
 * @return The stream.
 */ 
In& operator>>(In& stream,TacticEntryArray& tacticEntryArray);
 
/**
 * Streaming operator that writes a TacticEntryArray to a stream.
 * @param stream The stream to write on.
 * @param tacticEntryArray The TacticEntryArray object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const TacticEntryArray& tacticEntryArray);



#endif //__TacticEntry_h_

/*
 * Change log :
 * $Log: TacticEntry.h,v $
 * Revision 1.9  2004/01/19 20:13:08  kerdels
 * added name capability to tacticentrys
 *
 * Revision 1.8  2004/01/16 09:49:15  kerdels
 * updated comment
 *
 * Revision 1.7  2004/01/04 01:00:47  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.6  2003/12/29 21:35:12  kerdels
 * tactics beispiel hinzugefgt,
 * laden aus datei im tacticchooser
 *
 * Revision 1.5  2003/12/29 12:26:27  kerdels
 * global analysis hinzugefgt
 *
 * Revision 1.4  2003/12/28 19:03:30  kerdels
 * option rating dialog added
 *
 * Revision 1.3  2003/12/17 23:58:06  huelsbusch
 * startet work on option-choosing
 *
 * Revision 1.2  2003/12/13 13:21:38  kerdels
 * tacticEntry debugged
 *
 * Revision 1.1  2003/12/13 11:44:26  rossdeutscher
 * TacticEntry implementiert und inc repository gebaut.
 *
 *
 */

