/**
* @file FieldDimensions.h
*
* Description of the Dimensions of the Field.
*
* @author Matthias Jngel
* @author Thomas Rfer
*/

#ifndef __FieldDimensions_h_ 
#define __FieldDimensions_h_ 
#include "Math/Geometry.h"
#include "Math/Common.h"


//#undef LARGE_FIELD
//#define GLASSBOX

#ifdef LARGE_FIELD

static const int xPosOpponentGoal           =  2450;
static const int xPosFrontFlags             =  2200;
static const int xPosOpponentGoalpost       =  2200;
static const int xPosOpponentGroundline     =  2100;
static const int xPosOpponentSideCorner     =  1800;
static const int xPosOpponentPenaltyArea    =  1600;
static const int xPosCenterOpponentHalf     =  1200; // ???
static const int xPosHalfWayLine            =     0;

static const int xPosCenterOwnHalf          = -1200;
static const int xPosOwnPenaltyArea         = -1600;
static const int xPosOwnSideCorner          = -1800;
static const int xPosOwnGroundline          = -2100;
static const int xPosOwnGoalpost            = -2200;
static const int xPosBackFlags              = -2200;
static const int xPosOwnGoal                = -2450;

static const int yPosLeftFlags              =  1450;
static const int yPosLeftSideline           =  1350;
static const int yPosLeftGroundline         =  1050;
static const int yPosCenterLeftHalf         =   700; // ???
static const int yPosLeftPenaltyArea        =   500;
static const int yPosLeftGoal               =   300;
static const int yPosCenterGoal             =     0;
static const int yPosRightGoal              =  -300;
static const int yPosRightPenaltyArea       =  -500;
static const int yPosCenterRightHalf        =  -700; // ???
static const int yPosRightGroundline        = -1050;
static const int yPosRightSideline          = -1350;
static const int yPosRightFlags             = -1450;

//absolute koordinaten (fuer deckenkamera ...)
static const int xPosYellowGroundline       =  2100;
static const int xPosYellowSideCorner       =  1800;
static const int xPosYellowPenaltyArea      =  1600;
//static const int xPosHalfWayLine          =     0;
static const int xPosBluePenaltyArea        = -1600;
static const int xPosBlueSideCorner         = -1800;
static const int xPosBlueGroundline         = -2100;

//other dimesions
static const int centerCircleRadius         = 150;
static const double flagRadius              = 51.5;
static const int flagHeight                 = 200;
static const int flagColorHeight            = 100;
static const int goalHeight                 = 300;
static const int ballRadius                 = 43;
static const int soccerBallRadius           = 45;
static const int fieldLinesWidth            = 25; //?? check this!
static const int wallHeight                 = 100;

#else


// Field-dimensions for 60cm x 60cm glass-presentation-box. 
// This box has only 4 Landmarks and a green floor.

#ifdef GLASSBOX

static const int xPosOpponentGoal           =  301;
static const int xPosFrontFlags             =  265;
static const int xPosOpponentGoalpost       =  241;
static const int xPosOpponentGroundline     =  240;
static const int xPosOpponentSideCorner     =  240;
static const int xPosOpponentPenaltyArea    =  200;
static const int xPosCenterOpponentHalf     =  150;
static const int xPosHalfWayLine            =    0;

static const int xPosCenterOwnHalf          =  -150;
static const int xPosOwnPenaltyArea         =  -200;
static const int xPosOwnSideCorner          =  -240;
static const int xPosOwnGroundline          =  -240;
static const int xPosOwnGoalpost            =  -241;
static const int xPosBackFlags              =  -265;
static const int xPosOwnGoal                =  -301;

static const int yPosLeftFlags              =   265;
static const int yPosLeftSideline           =   240;
static const int yPosLeftPenaltyArea        =   150;
static const int yPosLeftGroundline         =   150;
static const int yPosCenterLeftHalf         =   150;
static const int yPosLeftGoal               =   150;
static const int yPosCenterGoal             =     0;
static const int yPosRightGoal              =  -150;
static const int yPosCenterRightHalf        =  -150;
static const int yPosRightGroundline        =  -150;
static const int yPosRightPenaltyArea       =  -150;
static const int yPosRightSideline          =  -240;
static const int yPosRightFlags             =  -265;

//absolute koordinaten (fuer deckenkamera ...)
static const int xPosYellowGroundline       =  1400;
static const int xPosYellowSideCorner       =  1100;
static const int xPosYellowPenaltyLine      =   950;
//static const int xPosHalfWayLine          =     0;
static const int xPosBluePenaltyLine        =  -950;
static const int xPosBlueSideCorner         = -1100;
static const int xPosBlueGroundline         = -1400;

//other dimesions
static const int centerCircleRadius = 1;
static const double flagRadius = 27;
static const int flagHeight = 100;
static const int goalHeight = 100;
static const int ballRadius = 43;
static const int soccerBallRadius = 49;
static const int fieldLinesWidth = 25; //?? check this!
static const int flagColorHeight            = 50;
static const int wallHeight                 = 100;


#else



static const int xPosOpponentGoal           =  1750;
static const int xPosFrontFlags             =  1531;
static const int xPosOpponentGoalpost       =  1470;
static const int xPosOpponentGroundline     =  1420;
static const int xPosOpponentSideCorner     =  1100;
static const int xPosOpponentPenaltyArea    =  1060;
static const int xPosCenterOpponentHalf     =   850;
static const int xPosHalfWayLine            =     0;

static const int xPosCenterOwnHalf          =  -850;
static const int xPosOwnPenaltyArea         = -1060;
static const int xPosOwnSideCorner          = -1100;
static const int xPosOwnGroundline          = -1420;
static const int xPosOwnGoalpost            = -1470;
static const int xPosBackFlags              = -1531;
static const int xPosOwnGoal                = -1750;

static const int yPosLeftFlags              =  1031;
static const int yPosLeftSideline           =   900;
static const int yPosLeftPenaltyArea        =   900;
static const int yPosLeftGroundline         =   600;
static const int yPosCenterLeftHalf         =   500;
static const int yPosLeftGoal               =   300;
static const int yPosCenterGoal             =     0;
static const int yPosRightGoal              =  -300;
static const int yPosCenterRightHalf        =  -500;
static const int yPosRightGroundline        =  -600;
static const int yPosRightPenaltyArea       =  -900;
static const int yPosRightSideline          =  -900;
static const int yPosRightFlags             = -1031;

//absolute koordinaten (fuer deckenkamera ...)
static const int xPosYellowGroundline       =  1400;
static const int xPosYellowSideCorner       =  1100;
static const int xPosYellowPenaltyLine      =   950;
//static const int xPosHalfWayLine          =     0;
static const int xPosBluePenaltyLine        =  -950;
static const int xPosBlueSideCorner         = -1100;
static const int xPosBlueGroundline         = -1400;

//other dimesions
static const int centerCircleRadius = 150;
static const double flagRadius = 50;
static const int flagHeight = 200;
static const int goalHeight = 300;
static const int ballRadius = 43;
static const int soccerBallRadius = 49;
static const int fieldLinesWidth = 25; //?? check this!
static const int flagColorHeight            = 100;
static const int wallHeight                 = 100;

#endif // GLASSBOX
#endif // smallfield




static const Vector2<int> 
  ownGroundlineLeft(xPosOwnGroundline,yPosLeftGroundline);
static const Vector2<int> 
  ownGroundlineRight(xPosOwnGroundline,yPosRightGroundline);
static const Vector2<int> 
  ownGoalRearPanelMiddle(xPosOwnGoal,yPosCenterGoal);
static const Vector2<int> 
  opponentGoalRearPanelMiddle(xPosOpponentGoal,yPosCenterGoal);
static const Vector2<int> 
  opponentGroundlineLeft(xPosOpponentGroundline,yPosLeftGroundline);
static const Vector2<int> 
  opponentGroundlineRight(xPosOpponentGroundline,yPosRightGroundline);


static const Vector2<int> 
  leftSideLineOwnEnd(xPosOwnSideCorner,yPosLeftSideline);
static const Vector2<int> 
  leftSideLineOpponentEnd(xPosOpponentSideCorner,yPosLeftSideline);
static const Vector2<int> 
  rightSideLineOwnEnd(xPosOwnSideCorner,yPosRightSideline);
static const Vector2<int> 
  rightSideLineOpponentEnd(xPosOpponentSideCorner,yPosRightSideline);

static const Vector2<int>
  ownGoalLeftPost(xPosOwnGroundline,yPosLeftGoal);
static const Vector2<int>
  ownGoalRightPost(xPosOwnGroundline,yPosRightGoal);
static const Vector2<int>
  opponentGoalLeftPost(xPosOpponentGroundline,yPosLeftGoal);
static const Vector2<int>
  opponentGoalRightPost(xPosOpponentGroundline,yPosRightGoal);

static const Vector2<int>
  ownGoalLeftRearPanel(xPosOwnGoal,yPosLeftGoal);
static const Vector2<int>
  ownGoalRightRearPanel(xPosOwnGoal,yPosRightGoal);
static const Vector2<int>
  opponentGoalLeftRearPanel(xPosOpponentGoal,yPosLeftGoal);
static const Vector2<int>
  opponentGoalRightRearPanel(xPosOpponentGoal,yPosRightGoal);
 


static const Geometry::Line leftWall
(leftSideLineOwnEnd,
 leftSideLineOpponentEnd - leftSideLineOwnEnd);

static const Geometry::Line opponentLeftCorner
(leftSideLineOpponentEnd,
 opponentGroundlineLeft - leftSideLineOpponentEnd);

static const Geometry::Line opponentLeftGroundline
(opponentGroundlineLeft,
 opponentGoalLeftPost - opponentGroundlineLeft);

static const Geometry::Line opponentGoalLeftWall
(opponentGoalLeftPost,
 opponentGoalLeftRearPanel - opponentGoalLeftPost);

static const Geometry::Line opponentGoalRearWall
(opponentGoalLeftRearPanel,
 opponentGoalRightRearPanel - opponentGoalLeftRearPanel);

static const Geometry::Line opponentGoalRightWall
(opponentGoalRightRearPanel,
 opponentGoalRightPost - opponentGoalRightRearPanel);

static const Geometry::Line opponentRightGroundline
(opponentGoalRightPost,
 opponentGroundlineRight - opponentGoalRightPost);

static const Geometry::Line opponentRightCorner
(opponentGroundlineRight,
 rightSideLineOpponentEnd - opponentGroundlineRight);

static const Geometry::Line rightWall
(rightSideLineOpponentEnd,
 rightSideLineOwnEnd - rightSideLineOpponentEnd);

static const Geometry::Line ownRightCorner
(rightSideLineOwnEnd,
 ownGroundlineRight - rightSideLineOwnEnd);

static const Geometry::Line ownRightGroundline
(ownGroundlineRight,
 ownGoalRightPost - ownGroundlineRight);

static const Geometry::Line ownGoalRightWall
(ownGoalRightPost,
 ownGoalRightRearPanel - ownGoalRightPost);

static const Geometry::Line ownGoalRearWall
(ownGoalRightRearPanel,
 ownGoalLeftRearPanel - ownGoalRightRearPanel);

static const Geometry::Line ownGoalLeftWall
(ownGoalLeftRearPanel,
 ownGoalLeftPost - ownGoalLeftRearPanel);

static const Geometry::Line ownLeftGroundline
(ownGoalLeftPost,
 ownGroundlineLeft - ownGoalLeftPost);

static const Geometry::Line ownLeftCorner
(ownGroundlineLeft,
 leftSideLineOwnEnd - ownGroundlineLeft);

/**
* Static class containing some useful functions
* regarding field dimensions.
*
* @author Max Risler
*/
class FieldDimensions 
{
public:
  /**
  * Returns true when p is inside the field.
  */
  static bool isInsideField(const Vector2<int> &p);

  /**
  * Returns true when (x,y) is inside the field.
  */
  static bool isInsideField(int x, int y)
  {
    return isInsideField (Vector2<int>(x,y));
  }

  /**
  * Returns true when p is inside one of the goals.
  */
  static bool isInsideGoal(const Vector2<int> &p);

  /**
  * Returns true when (x,y) is inside one of the goals.
  */
  static bool isInsideGoal(int x, int y)
  {
    return isInsideGoal (Vector2<int>(x,y));
  }

  /**
  * Returns true when p is inside the own goal.
  */
  static bool isInsideOwnGoal(const Vector2<int> &p);

  /**
  * Returns true when p is inside the opponent goal.
  */
  static bool isInsideOpponentGoal(const Vector2<int> &p);

  /**
  * Returns true when p is on the groundline of the own goal.
  */
  static bool isOnOwnGoalGroundline(const Vector2<int> &p);

  /**
  * Returns true when p is on the groundline of the opponent goal.
  */
  static bool isOnOpponentGoalGroundline(const Vector2<int> &p);

  /**
  * Returns the distance of p to opponents penalty area.
  */
  static double distanceToOpponentPenaltyArea(const Vector2<double> &p);

  /**
  * Returns the distance of p to own penalty area.
  */
  static double distanceToOwnPenaltyArea(const Vector2<double> &p);
  static double distanceToOwnPenaltyArea(const Pose2D &p);

  /**
  * Returns the distance to the nearest field border.
  */
  static double distanceToBorder(const Vector2<double> &p);

  /**
  * Returns the vector to the nearest field border.
  */
  static void vectorToBorder(const Vector2<double> &p, Vector2<double> &result);

  /**
  * Returns the vector to the nearest field border including the goals.
  */
  static void vectorToBorderIncludingGoals(const Vector2<double> &p, Vector2<double> &result);


  /**
  * Clips a line with the field
  * @param point1 The starting point of the line
  * @param point2 The end point of the line
  * @return states whether clipping was necessary (and done)
  */
  static bool clipLineWithField(
   Vector2<int>& point1, 
   Vector2<int>& point2
   );

   /**
  * Clips a line with the field and the areas inside the goals
  * @param point1 The starting point of the line
  * @param point2 The end point of the line
  * @return states whether clipping was necessary (and done)
  */
  static bool clipLineWithFieldAndGoalAreas(
   Vector2<int>& point1, 
   Vector2<int>& point2
   );
};

#endif //FieldDimensions
/*
 * Change log :
 * 
 * $Log: FieldDimensions.h,v $
 * Revision 1.3  2004/03/16 14:00:23  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.2  2004/03/15 17:11:41  hoffmann
 * - added ATH2004HeadControl
 * - added ATH2004LEDControl
 * - headmotiontester shows "tilt2"
 * - motion process updates odometry while no new robotPose is received, added to motion request
 * - some ui adjustments
 * - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
 *
 * Revision 1.2  2003/10/22 12:36:40  wachter
 * Added field-dimensions for a 60cm x 60cm presentation-box
 *
 * Revision 1.1  2003/10/07 10:13:21  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/07/05 11:57:47  kudlacik
 * Corrected BallRadius
 *
 * Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.12  2003/06/24 16:50:00  schmidt
 * soccerBallRadius added
 *
 * Revision 1.11  2003/06/10 18:07:25  juengel
 * Added methods: isInsideGoal, isInsideOwnGoal, isInsideOpponentGoal, isOnOwnGoalGroundline, isOnOpponentGoalGroundline, vectorToBorderIncludingGoals, clipLineWithField, clipLineWithFieldAndGoalAreas.
 *
 * Revision 1.10  2003/05/12 12:03:40  roefer
 * New penalty area size, corrected sample poses for blue players
 *
 * Revision 1.9  2003/05/08 01:08:28  risler
 * added opponentGoalRearPanelMiddle
 *
 * Revision 1.8  2003/05/05 14:52:17  dueffert
 * warnings removed
 *
 * Revision 1.7  2003/04/15 15:52:07  risler
 * DDD GO 2003 code integrated
 *
 * Revision 1.11  2003/04/07 17:08:05  dthomas
 * added gobehindballorthogonaltoborder, gotoball
 *
 * Revision 1.10  2003/04/04 10:59:21  max
 * moved field dimensions function in separate class
 * ddd-soccer: added option dribble-to-goal
 *
 * Revision 1.9  2003/04/03 17:22:40  dthomas
 * fix: added include to use function min
 *
 * Revision 1.8  2003/04/03 14:43:45  max
 * added border distance function to fielddimensions
 * changed goto cont rules to use parabolic function
 *
 * Revision 1.7  2003/03/26 17:46:21  max
 * added getDistanceToOwn/OpponentPenaltyArea
 *
 * Revision 1.6  2003/03/06 13:57:49  dueffert
 * commented unused methods out to reduce warnings
 *
 * Revision 1.5  2003/03/04 17:43:54  roefer
 * New penalty area
 *
 * Revision 1.4  2003/01/09 14:08:50  jhoffman
 * no message
 *
 * Revision 1.3  2002/09/22 18:40:53  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.2  2002/09/22 09:15:34  risler
 * Geometry.h moved to directory Math
 *
 * Revision 1.1  2002/09/10 15:53:58  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.4  2002/06/13 18:22:38  dueffert
 * vector to own goal rear panel middle added
 *
 * Revision 1.3  2002/06/07 12:41:11  risler
 * no message
 *
 * Revision 1.2  2002/06/07 12:11:25  risler
 * added isInsideField
 *
 * Revision 1.1.1.1  2002/05/10 12:40:32  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.10  2002/04/25 14:50:35  kallnik
 * changed double/float to Value
 * added several #include GTMath
 *
 * PLEASE use Value
 *
 * Revision 1.9  2002/03/29 21:26:41  roefer
 * Field now follows specification from Open-R website
 *
 * Revision 1.8  2002/03/29 17:34:39  roefer
 * Field now follows specification from Open-R website
 *
 * Revision 1.7  2002/02/19 14:25:00  roefer
 * Goal height corrected
 *
 * Revision 1.6  2002/01/23 13:58:50  kosen
 * ballRadius angepasst
 *
 * Revision 1.5  2002/01/22 14:55:15  juengel
 * ImageToPerceptCollection eingefhrt
 *
 * Revision 1.4  2001/12/31 08:42:43  roefer
 * Large field
 *
 * Revision 1.3  2001/12/10 17:47:10  risler
 * change log added
 *
 */
