#ifndef INIFILE_H
#define INIFILE_H

#ifdef WIN32
  // disable some annoying warnings
  //   C4503: decorated name length exceeded, name was truncated.
  //   C4786: identifier was truncated to '255' characters in the browser information.
  //
# pragma warning(disable:4503)
# pragma warning(disable:4786)
#endif

#include <map>
#include <string>

using namespace std;

class IniFile {
  private:
    struct lt_nocase {
      inline bool operator()(const string &x, const string &y) const
      {
        return stricmp(x.c_str(), y.c_str()) < 0;
      }
    };
    
    typedef  map<string, string, lt_nocase>  Keys;
    typedef  map<string, Keys,   lt_nocase>  Sections;

    Sections sections;

  public:
    IniFile();
    IniFile(const char *filename);

    bool   load(const char *filename);
    bool   save(const char *filename) const;
    
    void   removeKey(const char *section, const char *key);

    const char *getString(const char *section, const char *key, const char *def = "") const;
    int    getInt   (const char *section, const char *key, int def = 0) const;
    double getDouble(const char *section, const char *key, double def = 0) const;
    bool   getBool  (const char *section, const char *key, bool def = false) const;
    
    void   setString(const char *section, const char *key, const char *val);
    void   setInt   (const char *section, const char *key, int val);
    void   setDouble(const char *section, const char *key, double val);
    void   setBool  (const char *section, const char *key, bool val);
};

#endif

/**
 * Change log:
 *
 * $Log: IniFile.h,v $
 * Revision 1.1  2004/04/13 23:35:16  kindler
 * initial import
 *
 */
