/**
* @file Histogram.cpp
*
* Implementation of class Histogram.
* 
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#include "Histogram.h"

void Histogram::init()
{
  init(256);
}

void Histogram::init(int numberOfEntries)
{
  this->numberOfEntries = numberOfEntries;
  for(int i = 0; i < numberOfEntries; i++) value[i] = 0;
  
  numberOfAddedEntries = 0;
  sum = 0;
}

void Histogram::add(int index)
{
  if(index >= maxNumberOfEntries) return;
  value[index]++;

  numberOfAddedEntries++;
  sum += index;
}

int Histogram::getValue(int index)
{
  if(index >= maxNumberOfEntries) return 0;
  return value[index];
}

int Histogram::getNumberOfEntries()
{
  return numberOfEntries;
}

Histogram::HistogramID Histogram::getHistogramID()
{
  return histogramID;
}



double Histogram::getAverage()
{
  return (double)sum / (double)numberOfAddedEntries;
}

double Histogram::getAverageFrequencyOverAllEntries()
{
  return (double)numberOfAddedEntries / (double)numberOfEntries;
}

double Histogram::getAverageFrequencyOverUsedEntries()
{
  int numberOfUsedEntries = 0;
  for(int i = 0; i < numberOfEntries; i++) if(value[i] != 0) numberOfUsedEntries++;
  return (double)numberOfAddedEntries / (double)numberOfUsedEntries;
}

void Histogram::analyseClusters()
{
  numberOfClusters = 3;
  beginOfCluster[0] = 30;
  endOfCluster[0]   = 50;
  beginOfCluster[1] = 90;
  endOfCluster[1]   = 150;
  beginOfCluster[2] = 220;
  endOfCluster[2]   = 250;

  enum{inCluster, betweenClusters} state = betweenClusters;

  numberOfClusters = 0;
  int numberOfValuesSinceLastCluster = 0;
//  int numberOfValuesInThisCluster = 0;
  for(int index = 0; index < numberOfEntries; index++)
  {
    if(state == betweenClusters)
    {
      if(value[index] > getAverageFrequencyOverAllEntries())
/*        numberOfValuesInThisCluster++;
      else
        numberOfValuesInThisCluster = 0;
      if(numberOfValuesInThisCluster > 3)
*/
      {
        state = inCluster;
//        beginOfCluster[numberOfClusters] = index + 1 - numberOfValuesInThisCluster;
        beginOfCluster[numberOfClusters] = index;
//        numberOfValuesInThisCluster = 0;
      }
    }
    else // in cluster
    {
      if(value[index] <= getAverageFrequencyOverAllEntries())
        numberOfValuesSinceLastCluster++;
      else
        numberOfValuesSinceLastCluster = 0;
      if(numberOfValuesSinceLastCluster > 5)
      {
        state = betweenClusters;
        endOfCluster[numberOfClusters] = index - numberOfValuesSinceLastCluster;
        if(endOfCluster[numberOfClusters] - beginOfCluster[numberOfClusters] > 3) numberOfClusters++;
        numberOfValuesSinceLastCluster = 0;
      }
    }
  }
  if(state == inCluster)
  {
    endOfCluster[numberOfClusters] = numberOfEntries - 1;
    if(endOfCluster[numberOfClusters] - beginOfCluster[numberOfClusters] > 3) numberOfClusters++;
  }
}

int Histogram::getNumberOfClusters()
{
  return numberOfClusters;
}

int Histogram::getBeginOfCluster(int index)
{
  return beginOfCluster[index];
}

int Histogram::getEndOfCluster(int index)
{
  return endOfCluster[index];
}

In& operator>>(In& stream, Histogram& histogram)
{
  stream.read(&histogram,sizeof(Histogram));
  return stream;
}

Out& operator<<(Out& stream, Histogram& histogram)
{
  stream.write(&histogram,sizeof(Histogram));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: Histogram.cpp,v $
 * Revision 1.1  2003/10/07 10:13:24  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1  2003/09/26 11:40:40  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.3  2003/09/05 18:52:48  dueffert
 * warning removed
 *
 * Revision 1.2  2003/08/29 13:12:12  juengel
 * changed parameter in cluster method
 *
 * Revision 1.1  2003/08/25 17:19:39  juengel
 * Added Histogram
 *
 *
 */

