/** 
* @file Points3D.cpp
*
* Implementation of class Points3D
*
* @author Martin Ltzsch
*/ 

#include "Points3D.h"

Points3D::Points3D()
{
}

Points3D::~Points3D()
{
}

In& operator>>(In& stream,Points3D& points3D)
{
  int numberOfEntries;
  Vector3<double> v;
  points3D.init();

  stream >> numberOfEntries;
  for (int i=0; i< numberOfEntries; i++)
  {
    stream >> v.x >> v.y >> v.z;
    points3D.add(v);
  }
  return stream;
}

Out& operator<<(Out& stream, const Points3D& points3D)
{
  stream << points3D.getNumberOfEntries();
  for (int i=0; i< points3D.getNumberOfEntries(); i++)
  {
    stream << points3D[i].x << points3D[i].y << points3D[i].z;
  }
  return stream;
}

/*
* Change Log:
*
* $Log: Points3D.cpp,v $
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2002/10/10 13:09:50  loetzsch
* First experiments with the PSD Sensor
* - SensorDataProcessor now calculates PSDPercept
* - Added the PerceptBehaviorControl solution PSDTest
* - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
*
*/
