/**
* @file Points3D.h
* 
* Definition of class Points3D
*
* @author Martin Ltzsch
*/

#ifndef __Points3D_h_
#define __Points3D_h_

#include "Tools/Streams/InOut.h"
#include "Tools/RingBuffer.h"
#include "Vector3.h"

/** The maximum number of points that can be stored */
const int maxNumberOf3DPoints = 20;

/** 
* @class Points3D
* 
* A ring buffer for 3 dimensional points relative to the robot that can be 
* moved in x,y by odometry.
* 
* @author Martin Ltzsch
*/
class Points3D : public RingBuffer<Vector3<double>,maxNumberOf3DPoints>
{
public:
  /**Constructor */
  Points3D();
  
  /** Destructor */
  ~Points3D();
};

/**
* Streaming operator that reads a Points3D from a stream.
* @param stream The stream from which is read.
* @param points3D The Points3D object.
* @return The stream.
*/ 
In& operator>>(In& stream,Points3D& points3D);

/**
* Streaming operator that writes a Points3D to a stream.
* @param stream The stream to write on.
* @param points3D The Points3D object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const Points3D& points3D);


#endif //__Points3D_h_

/*
* Change Log:
*
* $Log: Points3D.h,v $
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2002/10/10 16:18:39  loetzsch
* some minor improvements and better doxygen comments
*
* Revision 1.1  2002/10/10 13:09:50  loetzsch
* First experiments with the PSD Sensor
* - SensorDataProcessor now calculates PSDPercept
* - Added the PerceptBehaviorControl solution PSDTest
* - Added the RadarViewer3D to RobotControl, which can display the Points3D structure
*
*/
