/**
 * @file Pose2D.cpp
 * Implementation of class Pose2D
 *
 * @author <a href="mailto:martin.kallnik@gmx.de">Martin Kallnik</a>
 * @author Max Risler
 */

#include "Pose2D.h"

#ifdef Pose2Dnew

In& operator>>(In& stream, RotationVector& rotationVector)
{
  stream >> rotationVector.sinus;
  stream >> rotationVector.cosinus;
  return stream;
}

Out& operator<<(Out& stream, const RotationVector& rotationVector)
{
  stream << rotationVector.sinus;
  stream << rotationVector.cosinus;
  return stream;
}

#endif //Pose2DNew

In& operator>>(In& stream, Pose2D& pose2D)
{
  stream >> pose2D.rotation;
  stream >> pose2D.translation;
  return stream;
}

Out& operator<<(Out& stream, const Pose2D& pose2D)
{
  stream << pose2D.rotation;
  stream << pose2D.translation;
  return stream;
}

/*
* Change log :
* 
* $Log: Pose2D.cpp,v $
* Revision 1.1  2003/12/02 13:44:56  cesarz
* added streaming operators
*
*/
