/**
 * @file Pose3D.cpp
 * Implementation of class Pose3D
 *
 * @author <a href="mailto:martin.kallnik@gmx.de">Martin Kallnik</a>
 * @author Max Risler
 */

#include "Pose3D.h"

In& operator>>(In& stream, Pose3D& pose3D)
{
  stream >> pose3D.rotation;
  stream >> pose3D.translation;
  return stream;
}

Out& operator<<(Out& stream, const Pose3D& pose3D)
{
  stream << pose3D.rotation;
  stream << pose3D.translation;
  return stream;
}

/*
* Change log :
* 
* $Log: Pose3D.cpp,v $
* Revision 1.1  2003/12/02 13:44:56  cesarz
* added streaming operators
*
*/

