/**
* @file InMessage.cpp
*
* Implementation of class InMessageQueue, InBinaryMessage, InTextMessage,
* InConfigMessage and InMessage.
*
* @author Martin Ltzsch
*/

#include "InMessage.h"

InMessageQueue::InMessageQueue() 
: queue(0) 
{
}

bool InMessageQueue::exists() const 
{ 
  return true; 
}

bool InMessageQueue::getEof() const 
{ 
  return (queue != 0 ? queue->eof() : false); 
}

void InMessageQueue::open(MessageQueueBase* q) 
{ 
  if (queue == 0) queue = q; 
}

void InMessageQueue::readFromStream(void* p,int size) 
{ 
  if (queue != 0) queue->read(p,size); 
}

InBinaryMessage::InBinaryMessage(MessageQueueBase* q) 
{ 
  open(q); 
}

InTextMessage::InTextMessage(MessageQueueBase* q) 
{ 
  open(q); 
}

void InTextMessage::readAll(char* buf)
{
  while(!getEof())
  {
    nextChar(*this);
    if (theChar != ' ') 
    {
      if(theChar == '\\') nextChar(*this);
      *buf++ = theChar;
    }    
  }
  *buf = 0;
}

InConfigMessage::InConfigMessage(MessageQueueBase* q) 
{ 
  open(q); 
}

InMessage::InMessage(MessageQueueBase& queue) 
: queue(queue), bin(&queue), text(&queue), config(&queue) 
{
}

unsigned long InMessage::getTimeStamp() const
{ 
  return queue.getTimeStamp(); 
}

MessageID InMessage::getMessageID() const
{ 
  return queue.getMessageID(); 
}

int InMessage::getMessageSize() const
{ 
  return queue.getMessageSize(); 
}
  
Player::teamColor InMessage::getTeamColor() const
{
  return queue.getTeamColor();
}

Player::playerNumber InMessage::getPlayerNumber() const
{
  return queue.getPlayerNumber();
}

int InMessage::getRobotNumber() const
{
  if (queue.getPlayerNumber()==Player::undefinedPlayerNumber) return 8;
  if (queue.getTeamColor()==Player::undefinedTeamColor) return 8;
  return (4*queue.getTeamColor()+queue.getPlayerNumber());
}
bool InMessage::getMessageWasSentFromAPhysicalRobot() const
{
  return queue.getMessageWasSentFromAPhysicalRobot();
}

void InMessage::resetReadPosition() 
{ 
  queue.resetReadPosition(); 
  config.reset();
  text.reset();
}

const char* InMessage::getData() const
{
  return queue.getData();
}

/*
* Change Log:
*
* $Log: InMessage.cpp,v $
* Revision 1.3  2003/12/06 23:39:07  loetzsch
* added getRobotNumber()
*
* Revision 1.2  2003/12/06 23:23:55  loetzsch
* messages in a MessageQueue now contain
* - the team color of the robot which sent the message
* - the player number of the robot which sent the message
* - if the message was sent from a physical robot or not
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:28  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/01/26 19:36:23  loetzsch
* config and text now are also reset in resetReadReadposition()
*
* Revision 1.1  2002/09/10 15:53:59  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/08/30 14:37:21  dueffert
* removed unused includes
*
* Revision 1.1  2002/07/23 13:47:14  loetzsch
* - new streaming classes
* - new debug message handling
* - exchanged StaticQueue by MessageQueue
*
*/
