/**
* @file PfieldConfig.h
* 
* This file contains global definitions for using the potential fields on
* different platforms
*
* @author <a href="mailto:timlaue@informatik.uni-bremen.de">Tim Laue</a>
*/


#ifndef PFIELD_CONFIG_H_
#define PFIELD_CONFIG_H_


//A global define, please change for your use
#define POTENTIALFIELDS_FOR_GT2004_


//Disable MS Visual C++ warnings about limited debugging information on STL containers
#ifdef _MSC_VER
#pragma warning (disable: 4786)
#endif


//Include some platform specific headers to get access to global functions and constants
#ifdef POTENTIALFIELDS_FOR_GT2004_
#include "Platform/SystemCall.h"
#include "Tools/Math/Common.h"
#else
/** constant for a half circle*/
const double pi = 3.1415926535897932384626433832795;
/** constant for a full circle*/
const double pi2 = 2.0*3.1415926535897932384626433832795;
/** constant for three quater circle*/
const double pi3_2 = 1.5*3.1415926535897932384626433832795;
/** constant for a quarter circle*/
const double pi_2 = 0.5*3.1415926535897932384626433832795;
/** constant for a 1 degree*/
const double pi_180 = 3.1415926535897932384626433832795/180;
/** constant for a 1/8 circle*/
const double pi_4 = 3.1415926535897932384626433832795*0.25;
/** constant for a 3/8 circle*/
const double pi3_4 = 3.1415926535897932384626433832795*0.75;
#endif //POTENTIALFIELDS_FOR_GT2004_


/** Time function*/
static unsigned long getSystemTime()
{ 
#ifdef POTENTIALFIELDS_FOR_GT2004_
  return SystemCall::getCurrentSystemTime();
#else
  return 0;
#endif //POTENTIALFIELDS_FOR_GT2004_
}


#endif  //PFIELD_CONFIG_H_



/*
* $Log: PfieldConfig.h,v $
* Revision 1.1  2004/01/20 15:42:19  tim
* Added potential fields implementation
*
* Revision 1.3  2003/06/13 14:27:58  tim
* added random generator and tangential fields
*
* Revision 1.2  2003/06/09 20:00:04  tim
* Changed potentialfield architecture
*
* Revision 1.1  2003/03/23 17:51:27  tim
* Added potentialfields
*
*/
