/**
* @file OutStreams.cpp
*
* Implementation of out stream classes.
*
* @author Thomas Rfer
* @author Martin Ltzsch
*/

#include "OutStreams.h"

void OutText::writeString(const char* value, PhysicalOutStream& stream)
{
  char c=' ';
  stream.writeToStream(&c,1);
  for(; *value; ++value)
  {
    if(*value == ' ')
      sprintf(buf,"\\ ");
    else if(*value == '\n')
      sprintf(buf,"\\\n");
    else if(*value == '\r')
      sprintf(buf,"\\\r");
    else if(*value == '\t')
      sprintf(buf,"\\\t");
    else if(*value == '\\')
      sprintf(buf,"\\\\");
    else
      sprintf(buf,"%c",*value);

    stream.writeToStream(buf,(int)strlen(buf));
  }
}

void OutText::writeData(const void *p,int size, PhysicalOutStream& stream)
{
  for(int i = 0; i < size; ++i)
    writeChar(*((const char*&) p)++, stream);
}

void OutTextRaw::writeString(const char* value, PhysicalOutStream& stream)
{
  stream.writeToStream(value,(int)strlen(value));
}

void OutTextRaw::writeData(const void *p,int size, PhysicalOutStream& stream)
{
  for(int i = 0; i < size; ++i)
    writeChar(*((const char*&) p)++, stream);
}

/*
* Change Log:
*
* $Log: OutStreams.cpp,v $
* Revision 1.3  2004/01/28 20:52:33  loetzsch
* Added the OutTextRaw stream writer.
*
* Revision 1.2  2003/11/30 01:53:21  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:13:24  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2002/09/10 15:53:59  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/08/22 14:41:04  risler
* added some doxygen comments
*
* Revision 1.1  2002/07/23 13:46:43  loetzsch
* - new streaming classes
*
*/
