<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.agents.xsl,v $
Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.1  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.11  2003/01/18 18:45:30  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created
- The option trees are painted by using a precompiled xml file "option-tree.xml"
  to improve compile speed.

Revision 1.10  2003/01/15 20:12:11  loetzsch
fixed a bug in the attribut "file-name" of the graph

Revision 1.9  2002/12/09 13:02:31  loetzsch
decimal-input-function added

Revision 1.8  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.7  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.6  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.5  2002/11/30 19:16:15  juengel
Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.

Revision 1.4  2002/11/30 13:48:59  loetzsch
option tree visualization for options and agents finished

Revision 1.3  2002/11/30 13:43:53  loetzsch
option tree visualization for options and agents finished

Revision 1.2  2002/11/27 15:33:52  loetzsch
- first version of option and option-definitions
- started debug symbol generation
- added VALIDATION target to Makefile

Revision 1.1  2002/11/26 15:02:34  loetzsch
- xabsl2 schema definition continued
  symbols basic-behaviors agents
- xabsl2 documentation startet
- Modularization of Xabsl instance files with XInclude and external entities
- Makefile introduced

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:import href="generate-documentation.option-tree.xsl"/>
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:param name="option-tree-xml"/>
	<xsl:template match="xabsl:agent-collection">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: Agents</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents"/>
								<xsl:call-template name="menu-agents"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>Agents</h1>
							<xsl:apply-templates select="xabsl:agent"/>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="xabsl:agent">
		<h2 id="agent.{@id}">
			<xsl:value-of select="@title"/>
		</h2>
		<p>
			<xsl:value-of select="@description"/>
		</p>
		<p>Option Graph:<br/>
			<dotml:graph>
				<xsl:attribute name="file-name">svg/agent_<xsl:value-of select="@id"/></xsl:attribute>
				<xsl:call-template name="paint-option-tree">
					<xsl:with-param name="root-option" select="@root-option"/>
					<xsl:with-param name="option-tree-xml" select="$option-tree-xml"/>
				</xsl:call-template>
			</dotml:graph>
		</p>
	</xsl:template>
</xsl:stylesheet>
