<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.menu.xsl,v $
Revision 1.2  2004/03/16 14:00:24  juengel
Integrated Improvments from "Gnne"
-ATH2004ERS7Behavior
-ATHHeadControl
-KickSelectionTable
-KickEditor

Revision 1.2  2004/03/05 10:53:05  loetzsch
changed encoding

Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.9  2003/05/02 22:32:43  loetzsch
bug fixes

Revision 1.8  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.7  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

Revision 1.6  2002/12/05 16:47:24  loetzsch
options now contain decision trees for each state

Revision 1.5  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.4  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.3  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.2  2002/11/27 15:33:52  loetzsch
- first version of option and option-definitions
- started debug symbol generation
- added VALIDATION target to Makefile

Revision 1.1  2002/11/26 15:02:34  loetzsch
- xabsl2 schema definition continued
  symbols basic-behaviors agents
- xabsl2 documentation startet
- Modularization of Xabsl instance files with XInclude and external entities
- Makefile introduced

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1">
	<xsl:output method="xml" indent="no"/>
	<xsl:template name="menu-xabsl2-logo">
		<tr>
			<td colspan="2" class="xabsl-2-logo-big">
				<a href="http://www.ki.informatik.hu-berlin.de/XABSL" title="The XABSL Web Site">&gt;xabsl 2</a>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="xabsl-2-logo-small">Behavior Documentation</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-agents-linked">
		<tr>
			<td colspan="2" class="menu-title">
				<a href="agents.html" title="All available agents">&gt;Agents</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-agents">
		<tr>
			<td colspan="2" class="menu-title">&gt;Agents</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-index-linked">
		<tr>
			<td colspan="2" class="menu-item">
				<br/>&gt;<a href="index.html" title="Start Page">Index</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-index">
		<tr>
			<td colspan="2" class="menu-item">
				<br/>&gt;Index</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-symbols-linked">
		<tr>
			<td colspan="2" class="menu-title">
				<a href="symbols.html" title="All available symbols">&gt;Symbols</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-symbols">
		<tr>
			<td colspan="2" class="menu-title">&gt;Symbols</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-basic-behaviors-linked">
		<tr>
			<td colspan="2" class="menu-title">
				<a href="basic-behaviors.html" title="All available basic behaviors">&gt;Basic Behaviors</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-basic-behaviors">
		<tr>
			<td colspan="2" class="menu-title">&gt;Basic Behaviors</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-options-linked">
		<tr>
			<td colspan="2" class="menu-title">
				<a href="options.html" title="All available options">&gt;Options</a>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-entry-options">
		<tr>
			<td colspan="2" class="menu-title">&gt;Options</td>
		</tr>
	</xsl:template>
	<xsl:template name="menu-basic-behaviors">
		<xsl:for-each select="xabsl:options/xabsl:option/xabsl:basic-behaviors[count(key('basic-behaviors',@id)[1] | .)=1]">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<a href="basic-behaviors.{@id}.html" title="{@description}">
						<xsl:value-of select="@title"/>
					</a>
				</td>
			</tr>
			<xsl:for-each select="xabsl:basic-behavior">
				<tr>
					<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="basic-behaviors.{../@id}.html#state.{@name}" title="{@description}">
							<xsl:value-of select="@name"/>
						</a>
					</td>
				</tr>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="menu-basic-behavior">
		<tr>
			<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<xsl:value-of select="@title"/>
			</td>
		</tr>
		<xsl:for-each select="xabsl:basic-behavior">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="basic-behaviors.{../@id}.html#{@name}" title="{@description}">
						<xsl:value-of select="@name"/>
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="menu-options">
		<xsl:for-each select="xabsl:option-definition">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<a href="option.{@name}.html" class="menu-item" title="{@description}">
						<xsl:value-of select="@name"/>
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="menu-symbols">
		<xsl:for-each select="xabsl:options/xabsl:option/xabsl:symbols[count(key('symbols',@id)[1] | .)=1]">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<a href="symbols.{@id}.html" title="{@description}">
						<xsl:value-of select="@title"/>
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="menu-agents">
		<xsl:for-each select="xabsl:agent">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<a href="agents.html#agent.{@id}" title="{@description}">
						<xsl:value-of select="@title"/>
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="menu-symbol">
		<tr>
			<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<xsl:value-of select="@title"/>
			</td>
		</tr>
		<xsl:if test="xabsl:decimal-input-symbol | xabsl:boolean-input-symbol | xabsl:enumerated-input-symbol">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="symbols.{@id}.html#input-symbols" title="All available input symbols">Input Symbols</a>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="xabsl:decimal-input-function">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="symbols.{@id}.html#input-functions" title="All available input functions">Input Functions</a>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="xabsl:enumerated-output-symbol">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="symbols.{@id}.html#output-symbols" title="All available output symbols">Output Symbols</a>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="xabsl:constant">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="symbols.{@id}.html#constants" title="All available constants">Constants</a>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="menu-option">
		<xsl:variable name="name" select="@name"/>
		<xsl:for-each select="xabsl:option-definitions/xabsl:option-definition[@name = $name]">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&gt;&gt;&#160;&#160;<xsl:value-of select="@name"/>
				</td>
			</tr>
		</xsl:for-each>
		<xsl:for-each select="xabsl:state">
			<tr>
				<td class="menu-item" nowrap="nowrap" colspan="2">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&gt;&gt;&gt;&#160;&#160;<a href="option.{../@name}.html#state.{@name}" title="State {@name}">
						<xsl:value-of select="@name"/>
					</a>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="xabsl:agent-collection">
		<table border="0" cellspacing="0" cellpadding="1">
			<!--<tr>
				<td colspan="2">
					<img src="Xabsl2Logo.gif"/>
				</td>
			</tr>-->
			<tr>
				<td colspan="2" class="xabsl-2-logo-big">>xabsl 2</td>
			</tr>
			<tr>
				<td colspan="2" class="xabsl-2-logo-small">Behavior Documentation</td>
			</tr>
			<tr>
				<td colspan="2" class="menu-item">
					<br/>><a href="index.html" title="Start Page">Index</a>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="menu-title">>Agents:</td>
			</tr>
			<tr>
				<xsl:for-each select="xabsl:agent">
					<tr>
						<td class="menu-item" nowrap="nowrap">>></td>
						<td>
							<a href="agent.{@id}.html" class="menu-item" title="{@description}">
								<xsl:value-of select="@title"/>
							</a>
						</td>
					</tr>
				</xsl:for-each>
			</tr>
			<tr>
				<td colspan="2" class="menu-title">>Symbols:</td>
			</tr>
			<tr>
				<xsl:for-each select="xabsl:agent/xabsl:symbols">
					<xsl:variable name="title" select="@title"/>
					<xsl:if test="count(preceding::xabsl:symbols[@title=$title])=0">
						<tr>
							<td class="menu-item" nowrap="nowrap">>></td>
							<td>
								<a href="symbols.{@id}.html" class="menu-item" title="{@description}">
									<xsl:value-of select="@title"/>
								</a>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tr>
			<tr>
				<td colspan="2" class="menu-title">>Basic Behaviors:</td>
			</tr>
			<tr>
				<xsl:for-each select="xabsl:agent/xabsl:basic-behaviors">
					<xsl:variable name="title" select="@title"/>
					<xsl:if test="count(preceding::xabsl:basic-behaviors[@title=$title])=0">
						<tr>
							<td class="menu-item" nowrap="nowrap">>></td>
							<td>
								<a href="basic-behaviors.{@id}.html" class="menu-item" title="{@description}">
									<xsl:value-of select="@title"/>
								</a>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tr>
			<tr>
				<td colspan="2" class="menu-title">>Options:</td>
			</tr>
			<tr>
				<xsl:for-each select="xabsl:agent/xabsl:option-definitions/xabsl:option-definition">
					<xsl:variable name="name" select="@name"/>
					<xsl:if test="count(preceding::xabsl:option-definition[@name=$name])=0">
						<tr>
							<td class="menu-item" nowrap="nowrap">>></td>
							<td>
								<a href="option.{@name}.html" class="menu-item" title="{@description}">
									<xsl:value-of select="@name"/>
								</a>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
