<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.pseudo-code.xsl,v $
Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.5  2003/09/20 16:34:16  loetzsch
renamed "following-option-..." to "subsequent-option-.." and
"following-basic-behavior-.." to "subsequent-basic-behavior-.."
for consistency with publications

Revision 1.4  2003/08/09 12:19:05  loetzsch
renamed question-mark-operator to conditional-expression

Revision 1.3  2003/07/23 22:25:52  loetzsch
implemented question mark operator

Revision 1.2  2003/07/21 19:18:06  loetzsch
- Xabsl2 AND and OR operators now can contain more than 2 operands
- speed improvements and cleanup

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.8  2003/05/05 17:47:55  loetzsch
added in Xabsl2:
- marking of states as target-states with attribute is-target-state="true"
- boolean expression "subsequent-option-reached-target-state"
- common-decision-tree

Revision 1.7  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.6  2003/01/15 14:47:35  loetzsch
some speed enhancements

Revision 1.5  2003/01/13 13:16:59  loetzsch
renamed element "option-parameter" to "option-parameter-ref"

Revision 1.4  2002/12/09 13:02:31  loetzsch
decimal-input-function added

Revision 1.3  2002/12/08 19:31:18  loetzsch
visualization of decision trees finished

Revision 1.2  2002/12/06 13:14:40  loetzsch
- complete decision trees
- allmost all id constraints
- decision tree pseudo code in documentation

Revision 1.1  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:key name="enumerated-input-symbols" match="//xabsl:enumerated-input-symbol" use="@name"/>
	<xsl:key name="decimal-input-symbols" match="//xabsl:decimal-input-symbol" use="@name"/>
	<xsl:key name="decimal-input-functions" match="//xabsl:decimal-input-function" use="@name"/>
	<xsl:key name="boolean-input-symbols" match="//xabsl:boolean-input-symbol" use="@name"/>
	<xsl:key name="constants" match="//xabsl:constant" use="@name"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:template name="pseudo-code">
		<xsl:param name="current-state"/>
		<table>
			<xsl:attribute name="class"><xsl:choose><xsl:when test="ancestor-or-self::xabsl:common-decision-tree">common-pseudo-code-frame</xsl:when><xsl:otherwise>pseudo-code-frame</xsl:otherwise></xsl:choose></xsl:attribute>
			<tr>
				<td>
					<table cellpadding="0" cellspacing="0">
						<xsl:choose>
							<xsl:when test="local-name(xabsl:*)='if'  or local-name(xabsl:*)='else-if'  or local-name(xabsl:*)='else'">
								<xsl:apply-templates>
									<xsl:with-param name="current-state" select="$current-state"/>
								</xsl:apply-templates>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<xsl:for-each select="xabsl:*">
										<xsl:call-template name="apply-template-in-new-table-cell"/>
									</xsl:for-each>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="apply-template-in-new-table-cell">
		<xsl:choose>
			<xsl:when test="local-name()='not' or local-name()='and' or local-name()='or'">
				<td>
					<xsl:apply-templates select="."/>
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td class="pseudo-code-cell">
					<xsl:apply-templates select="."/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="xabsl:if | xabsl:else-if">
		<xsl:param name="current-state"/>
		<tr>
			<td>
				<table cellpadding="0" cellspacing="0">
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td class="pseudo-code-left-bracket" nowrap="nowrap">
										<span class="bold">
											<xsl:if test="local-name()='if'">if</xsl:if>
											<xsl:if test="local-name()='else-if'">else&#160;if</xsl:if>
										</span>&#160;(</td>
									<xsl:for-each select="xabsl:condition">
										<xsl:for-each select="xabsl:*">
											<xsl:call-template name="apply-template-in-new-table-cell"/>
										</xsl:for-each>
										<td class="pseudo-code-right-bracket">)</td>
										<td class="pseudo-code-cell" align="right">
											<span class="italic">
												<span class="nowrap">&#160;&#160;&#160;// <xsl:value-of select="@description"/>
												</span>
											</span>
										</td>
									</xsl:for-each>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="4" class="pseudo-code-cell">{</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td class="pseudo-code-cell" nowrap="nowrap">&#160;&#160;</td>
									<td>
										<table cellpadding="0" cellspacing="0">
											<xsl:apply-templates/>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="4" class="pseudo-code-cell">}</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<xsl:if test="../../xabsl:common-decision-tree and count(following-sibling::xabsl:*)=0">
			<tr>
				<td>
					<table cellpadding="0" cellspacing="0">
						<tr>
							<td>
								<table cellpadding="0" cellspacing="0">
									<tr>
										<td colspan="4" class="pseudo-code-cell">
											<span class="bold">else</span>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table cellpadding="0" cellspacing="0">
									<tr>
										<td colspan="4" class="pseudo-code-cell">{</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="4">
								<table cellpadding="0" cellspacing="0">
									<tr>
										<td class="pseudo-code-cell" nowrap="nowrap">&#160;&#160;</td>
										<td>
											<xsl:for-each select="../../xabsl:state[@name=$current-state]/xabsl:decision-tree">
												<xsl:call-template name="pseudo-code"/>
											</xsl:for-each>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td>
								<table cellpadding="0" cellspacing="0">
									<tr>
										<td colspan="4" class="pseudo-code-cell">}</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="xabsl:else">
		<tr>
			<td>
				<table cellpadding="0" cellspacing="0">
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="4" class="pseudo-code-cell">
										<span class="bold">else</span>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="4" class="pseudo-code-cell">{</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="4">
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td class="pseudo-code-cell" nowrap="nowrap">&#160;&#160;</td>
									<td>
										<table cellpadding="0" cellspacing="0">
											<xsl:apply-templates/>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="4" class="pseudo-code-cell">}</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:transition-to-state">
		<tr>
			<td class="pseudo-code-cell">transition-to-state(<a href="#state.{@ref}">
					<xsl:value-of select="@ref"/>
				</a>);</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:condition"/>
	<xsl:template match="xabsl:or | xabsl:and">
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<table cellpadding="0" cellspacing="0">
						<tr>
							<td class="pseudo-code-left-bracket" nowrap="nowrap">(</td>
							<xsl:for-each select="xabsl:*[1]">
								<xsl:call-template name="apply-template-in-new-table-cell"/>
							</xsl:for-each>
							<td class="pseudo-code-right-bracket">)</td>
						</tr>
					</table>
				</td>
			</tr>
			<xsl:for-each select="xabsl:*[position()>1]">
				<tr>
					<td>
						<table cellpadding="0" cellspacing="0">
							<tr>
								<td nowrap="nowrap" class="pseudo-code-cell">
									<xsl:choose>
										<xsl:when test="local-name(..)='or'">||&#160;</xsl:when>
										<xsl:when test="local-name(..)='and'">&amp;&amp;&#160;</xsl:when>
									</xsl:choose>
								</td>
								<td>
									<table cellpadding="0" cellspacing="0">
										<tr>
											<td class="pseudo-code-left-bracket" nowrap="nowrap">(</td>
											<xsl:call-template name="apply-template-in-new-table-cell"/>
											<td valign="bottom" class="pseudo-code-right-bracket" nowrap="nowrap">)</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template match="xabsl:not">
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td class="pseudo-code-left-bracket" nowrap="nowrap">!(</td>
				<xsl:for-each select="xabsl:*[1]">
					<xsl:call-template name="apply-template-in-new-table-cell"/>
				</xsl:for-each>
				<td class="pseudo-code-right-bracket">)</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="xabsl:enumerated-input-symbol-comparison">
		<span class="nowrap">
			<a href="symbols.{key('enumerated-input-symbols',@ref)/../@id}.html#{@ref}" title="{key('enumerated-input-symbols',@ref)/@description}">
				<xsl:value-of select="@ref"/>
			</a>
		</span>
		<span class="nowrap"> == <span class="italic">
				<xsl:value-of select="@value"/>
			</span>
		</span>
	</xsl:template>
	<xsl:template match="xabsl:equal-to | xabsl:not-equal-to | xabsl:less-than | xabsl:less-than-or-equal-to | xabsl:greater-than | xabsl:greater-than-or-equal-to">
		<xsl:apply-templates select="xabsl:*[1]"/>
		<span class="nowrap">
			<xsl:choose>
				<xsl:when test="local-name()='equal-to'"> == </xsl:when>
				<xsl:when test="local-name()='not-equal-to'"> != </xsl:when>
				<xsl:when test="local-name()='less-than'"> &lt; </xsl:when>
				<xsl:when test="local-name()='less-than-or-equal-to'"> &lt; </xsl:when>
				<xsl:when test="local-name()='greater-than'"> > </xsl:when>
				<xsl:when test="local-name()='greater-than-or-equal-to'"> >= </xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="xabsl:*[2]"/>
		</span>
	</xsl:template>
	<xsl:template match="xabsl:plus | xabsl:minus | xabsl:multiply | xabsl:divide | xabsl:mod">(<xsl:apply-templates select="xabsl:*[1]"/>
		<span class="nowrap">
			<xsl:choose>
				<xsl:when test="local-name()='plus'"> + </xsl:when>
				<xsl:when test="local-name()='minus'"> - </xsl:when>
				<xsl:when test="local-name()='multiply'"> * </xsl:when>
				<xsl:when test="local-name()='divide'"> / </xsl:when>
				<xsl:when test="local-name()='mod'"> % </xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="xabsl:*[2]"/>)</span>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-symbol-ref">
		<a href="symbols.{key('decimal-input-symbols',@ref)/../@id}.html#{@ref}" title="{key('decimal-input-symbols',@ref)/@description}">
			<xsl:value-of select="@ref"/>
		</a>
	</xsl:template>
	<xsl:template match="xabsl:boolean-input-symbol-ref">
		<a href="symbols.{key('boolean-input-symbols',@ref)/../@id}.html#{@ref}" title="{key('boolean-input-symbols',@ref)/@description}">
			<xsl:value-of select="@ref"/>
		</a>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-function-call">
		<a href="symbols.{key('decimal-input-functions',@ref)/../@id}.html#{@ref}" title="{key('decimal-input-functions',@ref)/@description}">
			<xsl:value-of select="@ref"/>
		</a>(<xsl:for-each select="xabsl:with-parameter">
			<span class="nowrap">
				<xsl:apply-templates/>
				<xsl:if test="count(following-sibling::xabsl:*)>0">, </xsl:if>
			</span>
		</xsl:for-each>)</xsl:template>
	<xsl:template match="xabsl:constant-ref">
		<a href="symbols.{key('constants',@ref)/../@id}.html#{@ref}" title="{key('constants',@ref)/@description}  ({key('constants',@ref)/@value})">
			<xsl:value-of select="@ref"/>
		</a>
	</xsl:template>
	<xsl:template match="xabsl:conditional-expression">(<xsl:for-each select="xabsl:condition">
			<xsl:apply-templates/>
		</xsl:for-each>?<xsl:for-each select="xabsl:expression1">
			<xsl:apply-templates/>
		</xsl:for-each>:<xsl:for-each select="xabsl:expression2">
			<xsl:apply-templates/>
		</xsl:for-each>)</xsl:template>
	<xsl:template match="xabsl:option-parameter-ref">
		<xsl:variable name="option-name" select="ancestor::xabsl:option/@name"/>
		<xsl:variable name="ref" select="@ref"/>::<a href="option.{ancestor::xabsl:option/@name}.html" title="Option parameter {@ref}: {ancestor::xabsl:option/xabsl:option-definitions/xabsl:option-definition[@name=$option-name]/xabsl:parameter[@name=$ref]/@description}">
			<xsl:value-of select="@ref"/>
		</a>
	</xsl:template>
	<xsl:template match="xabsl:decimal-value">
		<xsl:value-of select="@value"/>
	</xsl:template>
	<xsl:template match="xabsl:subsequent-option-reached-target-state">subsequent-option-reached-target-state</xsl:template>
	<xsl:template match="xabsl:*" priority="-10000">
		<xsl:value-of select="local-name()"/>
	</xsl:template>
</xsl:stylesheet>
