<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.symbols-index.xsl,v $
Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.5  2003/05/03 01:27:31  loetzsch
table design

Revision 1.4  2003/05/03 01:00:36  loetzsch
some beautifications

Revision 1.3  2003/05/02 22:32:43  loetzsch
bug fixes

Revision 1.2  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.1  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1" xmlns:dotml="http://www.martin-loetzsch.de/DOTML">
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:key name="symbols" match="xabsl:agent-collection/xabsl:options/xabsl:option/xabsl:symbols" use="@id"/>
	<xsl:template match="xabsl:agent-collection">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: Symbols</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols"/>
								<xsl:call-template name="menu-symbols"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>Symbols</h1>
							<table border="0" cellpadding="4" cellspacing="0">
								<xsl:for-each select="xabsl:options/xabsl:option/xabsl:symbols[count(key('symbols',@id)[1] | .)=1]">
									<tr>
										<td class="bold">
											<div class="nowrap">
												<a href="symbols.{@id}.html" title="{@description}">
													<xsl:value-of select="@title"/>
												</a>
											</div>
										</td>
										<td>
											<xsl:value-of select="@description"/>
											<br/>
											<br/>
											<div class="menu-item">
												<xsl:for-each select="xabsl:*">
													<span class="nowrap">
														<a href="symbols.{../@id}.html#{@name}" title="{@description}">
															<xsl:value-of select="@name"/>
														</a>&#160;&#160;&#160;</span>
												</xsl:for-each>
											</div>
										</td>
									</tr>
									<tr>
										<td>&#160;</td>
									</tr>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
