<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
Change Log:
$Log: generate-documentation.symbols.xsl,v $
Revision 1.1  2003/10/07 10:13:25  cvsadm
Created GT2004 (M.J.)

Revision 1.1.1.1  2003/07/02 09:40:29  cvsadm
created new repository for the competitions in Padova from the 
tamara CVS (Tuesday 2:00 pm)

removed unused solutions

Revision 1.1  2003/06/25 01:19:51  loetzsch
created xabsl 2.1
Differences to xabsl2.0: No predefined conditions, documentation uses new dot

Revision 1.8  2003/04/21 20:53:34  loetzsch
made validation and code generation faster
- the element xabsl:agent doesn't contain any options anymore
- options are now included to agents.xml instead into several agents
- removed unused options

Revision 1.7  2003/01/18 18:43:39  loetzsch
- the menu for the documentation is not loaded from an xml file any mor
  but created created different for each documentation type.
- instead of one big "index.html", which contains a complete table of contents,
  a few seperate index pages are created

Revision 1.6  2002/12/09 13:02:31  loetzsch
decimal-input-function added

Revision 1.5  2002/12/04 19:06:46  loetzsch
some minor beautifications

Revision 1.4  2002/12/04 10:38:15  juengel
XABSL2 logo added, changed table cell structure.

Revision 1.3  2002/12/03 18:17:14  loetzsch
- predefined conditions
- stylesheets are now independend from output directory
- minor changes

Revision 1.2  2002/11/30 19:16:15  juengel
Moved BehaviorControl solution Xabsl2Berlin to Humboldt2003.

Revision 1.1  2002/11/26 15:02:34  loetzsch
- xabsl2 schema definition continued
  symbols basic-behaviors agents
- xabsl2 documentation startet
- Modularization of Xabsl instance files with XInclude and external entities
- Makefile introduced

-->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xabsl="http://www.ki.informatik.hu-berlin.de/XABSL2.1">
	<xsl:import href="generate-documentation.parameters.xsl"/>
	<xsl:import href="generate-documentation.menu.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:template match="xabsl:symbols">
		<html>
			<head>
				<title>XABSL2 Behavior Documentation: <xsl:value-of select="@title"/>
				</title>
				<link rel="stylesheet" type="text/css" href="styles.css">
					<xsl:text> </xsl:text>
				</link>
			</head>
			<body>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td class="menu-cell">
							<table border="0" cellspacing="0" cellpadding="1">
								<xsl:call-template name="menu-xabsl2-logo"/>
								<xsl:call-template name="menu-entry-index-linked"/>
								<xsl:call-template name="menu-entry-agents-linked"/>
								<xsl:call-template name="menu-entry-symbols-linked"/>
								<xsl:call-template name="menu-symbol"/>
								<xsl:call-template name="menu-entry-basic-behaviors-linked"/>
								<xsl:call-template name="menu-entry-options-linked"/>
							</table>
						</td>
						<td class="main-area">
							<h1>
								<xsl:value-of select="@title"/>
							</h1>
							<p>
							<xsl:value-of select="@description"></xsl:value-of>
							</p>
							<p>The formalized behavior references a variety of input and output symbols, which can stand for variables or functions of the agent's software. Constants are constant decimal values.</p>
		<xsl:if test="xabsl:decimal-input-symbol | xabsl:boolean-input-symbol | xabsl:enumerated-input-symbol">

							<h2 id="input-symbols">Input Symbols</h2>
							<table border="0" cellpadding="0" cellspacing="6">
								<tr>
									<td class="tablehead">Name</td>
									<td class="tablehead">Type</td>
									<td class="tablehead">Measure</td>
									<td class="tablehead">Description</td>
								</tr>
								<xsl:apply-templates select="xabsl:decimal-input-symbol | xabsl:boolean-input-symbol | xabsl:enumerated-input-symbol"/>
							</table></xsl:if>
									<xsl:if test="xabsl:decimal-input-function">

							<h2 id="input-functions">Input Functions</h2>
							<table border="0" cellpadding="0" cellspacing="6">
								<tr>
									<td class="tablehead">Name</td>
									<td class="tablehead">Measure</td>
									<td class="tablehead">Description / Parameters</td>
								</tr>
								<xsl:apply-templates select="xabsl:decimal-input-function"/>
							</table>
							
							</xsl:if>
									<xsl:if test="xabsl:enumerated-output-symbol">

							
							<h2 id="output-symbols">Output Symbols</h2>
							<table border="0" cellpadding="0" cellspacing="6">
								<tr>
									<td class="tablehead">Name</td>
									<td class="tablehead">Type</td>
									<td class="tablehead">Measure</td>
									<td class="tablehead">Description</td>
								</tr>
								<xsl:apply-templates select="xabsl:enumerated-output-symbol"/>
							</table>
							
							</xsl:if>
		<xsl:if test="xabsl:constant">
							
							
							
							<h2 id="constants">Constants</h2>
							<table border="0" cellpadding="0" cellspacing="6">
								<tr>
									<td class="tablehead">Name</td>
									<td class="tablehead">Value</td>
									<td class="tablehead">Measure</td>
									<td class="tablehead">Description</td>
								</tr>
								<xsl:apply-templates select="xabsl:constant"/>
							</table>
							
							</xsl:if>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-symbol">
		<tr id="{@name}">
			<td class="bold">
				<xsl:value-of select="@name"/>
			</td>
			<td>decimal</td>
			<td class="italic">
				<xsl:value-of select="@measure"/>
			</td>
			<td>
				<xsl:value-of select="@description"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:decimal-input-function">
		<tr id="{@name}">
			<td class="bold">
				<xsl:value-of select="@name"/>
			</td>
			<td class="italic">
				<xsl:value-of select="@measure"/>
			</td>
			<td>
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<td colspan="2">&#160;</td>
			<td>
				<xsl:call-template name="parameters"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:boolean-input-symbol">
		<tr id="{@name}">
			<td class="bold">
				<xsl:value-of select="@name"/>
			</td>
			<td>boolean</td>
			<td class="italic">true/ false</td>
			<td>
				<xsl:value-of select="@description"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:enumerated-input-symbol | xabsl:enumerated-output-symbol">
		<tr id="{@name}">
			<td class="bold">
				<xsl:value-of select="@name"/>
			</td>
			<td>enumerated</td>
			<td class="italic">
				<xsl:for-each select="xabsl:enum-element">
					<xsl:value-of select="@name"/>
					<br/>
				</xsl:for-each>
			</td>
			<td>
				<xsl:value-of select="@description"/>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="xabsl:constant">
		<tr id="{@name}">
			<td class="bold">
				<xsl:value-of select="@name"/>
			</td>
			<td>
				<xsl:value-of select="@value"/>
			</td>
			<td class="italic">
				<xsl:value-of select="@measure"/>
			</td>
			<td>
				<xsl:value-of select="@description"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
