// MP3ToolDoc.cpp : implementation of the CMP3ToolDoc class
//

#include <afxwin.h>
#include "stdafx.h"
#include "MP3Tool.h"
#include "MP3ToolDoc.h"
#include "MP3ToolView.h"

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolDoc

IMPLEMENT_DYNCREATE(CMP3ToolDoc, CDocument)

BEGIN_MESSAGE_MAP(CMP3ToolDoc, CDocument)
//{{AFX_MSG_MAP(CMP3ToolDoc)
ON_COMMAND(ID_ADD_MP3S, OnAddMP3s)
ON_COMMAND(ID_SUB_MP3S, OnSubMP3s)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolDoc construction/destruction

CMP3ToolDoc::CMP3ToolDoc()
{
	willKeinNeues=false;
	myModifiedFlag=false;
}

CMP3ToolDoc::~CMP3ToolDoc()
{
}

const int CMP3ToolDoc::_gnColumnWidth[NUM_COLUMNS] = 
{200, 70, 100, 100, 100, 60, 60,
50, 40, 100,21,30,21,21};

LPCTSTR CMP3ToolDoc::_gszColumnLabel[NUM_COLUMNS] =
{
	_T("Datei"), _T("Pfad"), _T("Titel"), _T("Interpret"),_T("Album"), _T("Gre"), _T("Lnge"),
		_T("Genre"),_T("Jahr"), _T("Kommentar"),_T("Track#"),_T("Bitrate"),_T(""),_T("")
};

BOOL CMP3ToolDoc::OnNewDocument()
{
	if (willKeinNeues)
	{
		willKeinNeues=false;
		return false;
	}
	BeginWaitCursor();
	if (!CDocument::OnNewDocument())
	{
		EndWaitCursor();
		return false;
	}
	nixMehrDa=false;
	SetTitle("");
	EndWaitCursor();
	return true;
}

BOOL CMP3ToolDoc::CanCloseFrame( CFrameWnd* pFrame )
{
	if (myModifiedFlag)
	{
		SetModifiedFlag(true);
		return SaveModified();
	}
	return true;
}

void CMP3ToolDoc::OnCloseDocument() 
{
	DeleteContents();
	nixMehrDa=true;
	CFile f;
	if (f.Open("c:\\temp.jpg",CFile::modeCreate|CFile::modeWrite,NULL))
	{
		f.Close();
		f.Remove("c:\\temp.jpg");
	}
	CDocument::OnCloseDocument();
}

LPCTSTR CMP3ToolDoc::GetItem(CMP3ToolEntry* entry, int col)
{
	switch (col)
	{
	case COL_NAME:
		return entry->m_strName;
	case COL_PATH:
		return entry->m_strPath;
	case COL_TITLE:
		return entry->m_strTitle;
	case COL_ARTIST:
		return entry->m_strArtist;
	case COL_ALBUM:
		return entry->m_strAlbum;
	case COL_SIZE:
		_ltoa(entry->m_iSize,entry->tmp_Size,10);
		return entry->tmp_Size;
	case COL_LEN:
		entry->GetLength();
		return entry->len_s;
	case COL_TRACK:
    if (entry->m_iTrack==0)
    {
      entry->tmp_Track[0]=0;
    }
    else
    {
   		_itoa(entry->m_iTrack,entry->tmp_Track,10);
    }
		return entry->tmp_Track;
	case COL_GENRE:
		return entry->GetGenre();
	case COL_YEAR:
    if (entry->m_iYear==1900)
    {
      entry->tmp_Year[0]=0;
    }
    else
    {
		  _itoa(entry->m_iYear,entry->tmp_Year,10);
    }
		return entry->tmp_Year;
	case COL_COMMENT:
		return entry->m_strComment;
	case COL_BITRATE:
		if (entry->GetMBitRate() % 1000==0)
		{
			_itoa(entry->GetMBitRate()/1000,entry->tmp_Bit,10);
		}
		else
		{
			sprintf(entry->tmp_Bit,"%i.%i%i",entry->GetMBitRate()/1000,(entry->GetMBitRate()/100)%10,(entry->GetMBitRate()/10)%10);
		}
		return entry->tmp_Bit;
	case COL_ORIG:
		if (entry->Get_OrigFlag())
		{
			return _T("ja");
		}
		else
		{
			return _T("");
		}
		break;
	case COL_COPY:
		if (entry->Get_CopyFlag())
		{
			return _T("ja");
		}
		else
		{
			return _T("");
		}
		break;
	default:
		return _T("ERROR");
	}
}

WORD CMP3ToolDoc::MakeXLSLabel(LPBYTE ziel, LPTSTR quel, WORD row, WORD col)
{
	BYTE leng = (BYTE)(new CString(quel))->GetLength();
	*(LPWORD)ziel = 0x04;
	*(LPWORD)(ziel+2) = leng+8;
	*(LPWORD)(ziel+4) = row;
	*(LPWORD)(ziel+6) = col;
	*(ziel+8) = 0x40;
	*(ziel+9) = 0x00;
	*(ziel+10) = 0x00;
	*(ziel+11) = leng;
	strcpy((LPTSTR)(ziel+12), quel);
	return (WORD)(leng+12);
}

WORD CMP3ToolDoc::MakeXLSInt(LPBYTE ziel, short myint, WORD row, WORD col)
{
	*(LPWORD)ziel = 0x02;
	*(LPWORD)(ziel+2) = 9;
	*(LPWORD)(ziel+4) = row;
	*(LPWORD)(ziel+6) = col;
	*(ziel+8) = 0x40;
	*(ziel+9) = 0x00;
	*(ziel+10) = 0x00;
	*(PSHORT)(ziel+11) = myint;
	return 13;
}

WORD CMP3ToolDoc::MakeXLSNumb(LPBYTE ziel, double mydouble, WORD row, WORD col)
{
	*(LPWORD)ziel = 0x03;
	*(LPWORD)(ziel+2) = 15;
	*(LPWORD)(ziel+4) = row;
	*(LPWORD)(ziel+6) = col;
	*(ziel+8) = 0x40;
	*(ziel+9) = 0x00;
	*(ziel+10) = 0x00;
	*(double*)(ziel+11) = mydouble;
	return 19;
}

WORD CMP3ToolDoc::MakeXLSRow(LPBYTE row, CMP3ToolEntry* eintr,WORD entryx)
{
	WORD lang;
	lang = MakeXLSLabel(row, eintr->m_strTitle, entryx, 0);
	lang += MakeXLSLabel(row+lang, eintr->m_strArtist, entryx, 1);
	lang += MakeXLSLabel(row+lang, eintr->m_strAlbum, entryx, 2);
	lang += MakeXLSNumb(row+lang, (double)eintr->m_iSize, entryx, 3);
	lang += MakeXLSLabel(row+lang, eintr->GetGenre(), entryx, 4);
	lang += MakeXLSLabel(row+lang, eintr->m_strComment, entryx, 5);
	
	return lang;
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolDoc serialization

void CMP3ToolDoc::Serialize(CArchive& ar)
{
	POSITION pos = GetFirstViewPosition();
	CMP3ToolView* myView = (CMP3ToolView*)GetNextView(pos);
	CMP3ToolEntry* entry;
	
	BeginWaitCursor();
	int neu_items;
	if (ar.IsStoring())
	{
		neu_items = myView->GetListCtrl().GetItemCount();
		ar << neu_items;
		int k = myView->GetListCtrl().GetNextItem(-1,LVNI_ALL);
		while (k >= 0)
		{
			entry = (CMP3ToolEntry*)myView->GetListCtrl().GetItemData(k);
			entry->Serialize(ar);
			k = myView->GetListCtrl().GetNextItem(k,LVNI_ALL);
		}
	}
	else
	{
		ar >> neu_items;
		myView->InitTable();
		myView->GetListCtrl().SetItemCount(neu_items);
		for (int i=0;i<neu_items;i++)
		{
			entry = new CMP3ToolEntry();
			entry->Serialize(ar);
			myView->InsertEntry(entry, false, NULL);
		}
	}
	EndWaitCursor();
	SetModifiedFlag(false);
	myModifiedFlag=false;
}

/////////////////////////////////////////////////////////////////////////////
// CMP3ToolDoc commands

void CMP3ToolDoc::OnAddMP3s() 
{
	POSITION pos = GetFirstViewPosition();
	CMP3ToolView* myView = (CMP3ToolView*)GetNextView(pos);
	CMP3ToolEntry* entry;
	
	CFileDialog* mp3dialog;
	mp3dialog = new CFileDialog(true, _T("mp3"),"",OFN_ALLOWMULTISELECT,"MP3-Dateien (*.mp3)|*.mp3|MP3-Listen (*.m3l)|*.m3l|Alle Dateien (*.*)|*.*||",NULL);
	mp3dialog->m_ofn.lpstrFile = new char[60000];
	strcpy(mp3dialog->m_ofn.lpstrFile,_T(""));
	mp3dialog->m_ofn.nMaxFile = 60000;
	if (mp3dialog->DoModal()==IDOK)
	{
		BeginWaitCursor();
		POSITION posi = mp3dialog->GetStartPosition();
		int status=0;
		while ((posi !=0)&&(status<6))
		{
      CString fnam(mp3dialog->GetNextPathName(posi));
      if (fnam.Mid(fnam.GetLength()-4,4).Compare(".m3l")==0)
      {
        CFile fil(fnam,CFile::modeRead|CFile::shareDenyWrite);
        CArchive ar(&fil,1); //0=schreiben, 1=lesen
        int neu_items;
     		ar >> neu_items;
    		for (int i=0;i<neu_items;i++)
		    {
  			  entry = new CMP3ToolEntry();
          entry->Serialize(ar);
  				myView->InsertEntry(entry, true, &status);
	  			if ((status!=3)&&(status!=6))
		  		{
			  		myModifiedFlag=true;
				  }
          else if (status==6)
          {
            break;
          }
        }
      }
      else
      {
			  entry = new CMP3ToolEntry(fnam);
			  if (entry->KENN==0)
			  {
				  delete(entry);
			  }
			  else
			  {
				  myView->InsertEntry(entry, true, &status);
				  if ((status!=3)&&(status!=6))
				  {
					  myModifiedFlag=true;
				  }
			  }
      }
		}
		EndWaitCursor();
		SetTitle("");
	}
	//die add-dir variante kann ich mir wahrscheinlich schenken, wobei rekursiv ja nett wre
	/*	m_NumItems = 0;
	CFileFind ff;
	BOOL bFound = ff.FindFile("g:/mp3_ok/*.mp3");
	while (bFound)
	{
	   bFound = ff.FindNextFile();
	   entry = new CMP3ToolEntry("m:/mp3_ok/",ff.GetFileName());
	   myView->InsertEntry(entry, true, &state);
	}
	*/
  delete mp3dialog->m_ofn.lpstrFile;
  delete mp3dialog;
}

void CMP3ToolDoc::OnSubMP3s() 
{
	POSITION pos = GetFirstViewPosition();
	CMP3ToolView* myView = (CMP3ToolView*)GetNextView(pos);
	CMP3ToolEntry* entry;
	
	CFileDialog* mp3dialog;
	mp3dialog = new CFileDialog(true, _T("mp3"),"",OFN_ALLOWMULTISELECT,"MP3-Dateien (*.mp3)|*.mp3|MP3-Listen (*.m3l)|*.m3l|Alle Dateien (*.*)|*.*||",NULL);
	mp3dialog->m_ofn.lpstrFile = new char[60000];
	strcpy(mp3dialog->m_ofn.lpstrFile,_T(""));
	mp3dialog->m_ofn.nMaxFile = 60000;
	if (mp3dialog->DoModal()==IDOK)
	{
		BeginWaitCursor();
		POSITION posi = mp3dialog->GetStartPosition();
		int status=0;
		while (posi !=0)
		{
      CString fnam=mp3dialog->GetNextPathName(posi);
      if (fnam.Mid(fnam.GetLength()-4,4).Compare(".m3l")==0)
      {
        CFile fil(fnam,CFile::modeRead|CFile::shareDenyWrite);
        CArchive ar(&fil,1); //0=schreiben, 1=lesen
        int neu_items;
     		ar >> neu_items;
    		for (int i=0;i<neu_items;i++)
		    {
  			  entry = new CMP3ToolEntry();
          entry->Serialize(ar);
  				myView->SubEntry(entry, &status);
				  if (status==1)
				  {
					  myModifiedFlag=true;
          }
        }
      }
      else
      {
			  entry = new CMP3ToolEntry(fnam);
			  if (entry->KENN==0)
			  {
				  delete(entry);
			  }
			  else
			  {
				  myView->SubEntry(entry, &status);
				  if (status==1)
				  {
					  myModifiedFlag=true;
          }
				}
			}
		}
		EndWaitCursor();
		SetTitle("");
	}
  delete mp3dialog->m_ofn.lpstrFile;
  delete mp3dialog;
}


CString CMP3ToolDoc::GetChanged()
{
	if (myModifiedFlag)
	{
		return " *";
	}
	else
	{
		return "";
	}
}

void CMP3ToolDoc::SetTitle(LPCTSTR lpszTitle)
{
	if(strlen(lpszTitle)>0)
	{
		m_winTitle=lpszTitle;
	}
	CDocument::SetTitle(m_winTitle+GetChanged());
}

void CMP3ToolDoc::DeleteContents()
{
	if (nixMehrDa)
	{
		return;
	}
	POSITION pos = GetFirstViewPosition();
	CListCtrl& ListCtrl = ((CMP3ToolView*)GetNextView(pos))->GetListCtrl();
	int nItem = -1;
	while ((nItem = ListCtrl.GetNextItem(nItem, LVNI_ALL))!=-1)
	{
		delete ((CMP3ToolEntry*)(ListCtrl.GetItemData(nItem)));
	}
	ListCtrl.DeleteAllItems();
}

BOOL CMP3ToolDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	char* ext=new char[30];
	int status=0;
	_splitpath(lpszPathName,NULL,NULL,NULL,ext);
	if (stricmp(ext,".m3l")==0)
	{
		if (myModifiedFlag)
		{
			SetModifiedFlag(true);
			if (!SaveModified())
			{
				delete ext;
				SetModifiedFlag(false);
				willKeinNeues=true;
				return false;
			}
			SetModifiedFlag(false);
		}
		if (CDocument::OnOpenDocument(lpszPathName))
		{
			delete ext;
			return true;
		}
	}
	if ((stricmp(ext,".mp3")==0))
	{
		POSITION pos = GetFirstViewPosition();
		CMP3ToolView* myView = (CMP3ToolView*)GetNextView(pos);
		CMP3ToolEntry* entry = new CMP3ToolEntry(lpszPathName);
		if (entry->KENN==0)
		{
			delete(entry);
		}
		else
		{
			myView->InsertEntry(entry, true, &status);
			if ((status!=3)&&(status!=6))
			{
				myModifiedFlag=true;
				SetTitle("");
			}
		}
	}
	delete ext;
	return false;
}
