// MP3ToolEntry.h: interface for the CMP3ToolEntry class.
//
//////////////////////////////////////////////////////////////////////

#ifndef CMP3ToolEntry__H
#define CMP3ToolEntry__H

#include "AutoDlg.h"
enum chg_type {chgID3,chgFRONT,chgBACK,chgFLAG,chgNAME,chgERR};

class CMP3ToolEntry : public CObject
{
	DECLARE_DYNCREATE(CMP3ToolEntry)
		
	//Construction
protected:
	void DoAlloc();
public:
	CMP3ToolEntry();
	CMP3ToolEntry(LPCTSTR datnam);
	virtual ~CMP3ToolEntry();
	
	//Overrides
	//{{AFX_VIRTUAL(CMP3ToolEntry)
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL
	
	//Attributes
	static LPCTSTR _cGenre[150];
	static const int _cBitrate[4][4][16];
	static const int _cSamplerate[4][4];
	static const int _cFrameLen[4][4];
	static LPCTSTR _cVersion[4];
	static LPCTSTR _cLayer[4];
	static LPCTSTR _cChannel[4];
	static LPCTSTR _cEmphasis[4];
	
	LPTSTR m_strName;
	CString m_strNewName;
	LPTSTR m_strPath;
	LPTSTR m_strTitle;
	LPTSTR m_strArtist;
	LPTSTR m_strAlbum;
	int m_iYear;
	int m_iGenre;
	long m_iSize;
	LPTSTR m_strComment;
	
	int wahrAnf;
	int wahrEnd;
	int changed;
	char scanned;
	char id3_jpg;   //wird beim laden/speichern der m3ls ignoriert
	char len_s[20];

	LPTSTR tmp_Track;
	LPTSTR tmp_Year;
	LPTSTR tmp_Bit;
	LPTSTR tmp_Size;

protected:
	CString addMyStr(LPTSTR orig);
	
	//Implementation
public:
	void ScanMP3(CString datnam);
	unsigned long KENN;
	int m_iMSec;
	int m_iMBitRate;
	int m_iFrameAnz;
  unsigned char m_iTrack;
	LPTSTR GetGenre();
	int GetMBitRate();
	int GetSampleRate();
	int GetFrameAnz();
	CString GetTyp();
	CString GetLength();
	LPTSTR GetChannel();
	LPTSTR GetEmphasis();
	bool Get_CrcFlag();
	bool Get_OrigFlag();
	bool Get_CopyFlag();
	void Set_OrigFlag(bool setIt);
	void Set_CopyFlag(bool setIt);
	void GetFrameStuff();
	void UpdateChanged();
	void SaveChanges();
	void shortenString(char* s, char* t);
	bool equals(CMP3ToolEntry* e);
	
	int AutoEdit(CAutoDlg* autoDlg);
};
#endif