// MP3ToolView.h : interface of the CMP3ToolView class
//

#ifndef CMP3ToolView__H
#define CMP3ToolView__H

class CMP3ToolView : public CListView
{
	DECLARE_DYNCREATE(CMP3ToolView)
		
	//Construction
protected:
	CMP3ToolView();
	
	// Attributes
public:
	CMP3ToolDoc* GetDocument();
	//	COleDropTarget m_dropTarget;
	
	// Overrides
protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMP3ToolView)
public:
	virtual void OnDraw(CDC* pDC);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	//	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	//	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	//	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	virtual ~CMP3ToolView();
	void UpdateViewEntry(int i);
	void InitTable();
	void InsertEntry(CMP3ToolEntry* entry, BOOL checkdouble, int* state);
	void SubEntry(CMP3ToolEntry* entry, int* state);
	
protected:
	static LPCTSTR MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset);
	void RepaintSelectedItems();
	
	COLORREF m_clrText;
	COLORREF m_clrTextBk;
	COLORREF m_clrBkgnd;
	
	BOOL tabelle_schon_initialisiert;
	
	// Generated message map functions
protected:
	//{{AFX_MSG(CMP3ToolView)
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnViewStateIcons();
	afx_msg void OnUpdateViewStateIcons(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnColumnclick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnExpXls();
	afx_msg void OnAutoEdit();
	afx_msg void OnManEdit();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnPlay();
	afx_msg void OnExpWinamp();
	afx_msg void OnDelEntry();
	afx_msg void OnExpTxt();
	afx_msg void OnMakeCover();
	afx_msg void OnSearchFull();
	afx_msg void OnSearchSim();
	afx_msg void OnSearchReset();
	afx_msg void OnMove();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
		
protected:
	CImageList m_StateImageList;
	BOOL m_bStateIcons;
	BOOL m_bStrg;		//true, solange Strg gedrueckt ist (Strg-Enter=Autoedit)
	CAutoDlg* autoDlg;
};

inline CMP3ToolDoc* CMP3ToolView::GetDocument()
{ return (CMP3ToolDoc*)m_pDocument; }

#endif